/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class CacheKeyBuilder {
    public static final String NULL_KEYS_NOT_SUPPORTED_MSG = "Null keys are not supported by the Quarkus application data cache";

    public static Object buildDefault(String cacheName) {
        return new DefaultCacheKey(cacheName);
    }

    public static Object build(List<Object> keyElements) {
        if (keyElements == null || keyElements.isEmpty()) {
            throw new IllegalArgumentException("At least one key element is required to build a cache key");
        }
        if (keyElements.size() == 1) {
            if (keyElements.get(0) == null) {
                throw new NullPointerException(NULL_KEYS_NOT_SUPPORTED_MSG);
            }
            return keyElements.get(0);
        }
        return new CompositeCacheKey(keyElements);
    }

    private static class CompositeCacheKey {
        private final Object[] keyElements;

        public CompositeCacheKey(List<Object> keyElements) {
            this.keyElements = keyElements.toArray(new Object[0]);
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.keyElements);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (CompositeCacheKey.class.isInstance(obj)) {
                CompositeCacheKey other = (CompositeCacheKey)obj;
                return Arrays.deepEquals(this.keyElements, other.keyElements);
            }
            return false;
        }
    }

    private static class DefaultCacheKey {
        private final String cacheName;

        public DefaultCacheKey(String cacheName) {
            this.cacheName = cacheName;
        }

        public int hashCode() {
            return Objects.hash(this.cacheName);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof DefaultCacheKey) {
                DefaultCacheKey other = (DefaultCacheKey)obj;
                return Objects.equals(this.cacheName, other.cacheName);
            }
            return false;
        }
    }
}

