/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.codestarts.extension.QuarkusExtensionCodestartCatalog;
import io.quarkus.devtools.codestarts.extension.QuarkusExtensionCodestartProjectInput;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.maven.utilities.PomTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;

public class CreateExtensionCommandHandler {
    final String artifactId;
    final String groupId;
    final QuarkusExtensionCodestartProjectInput input;
    final Path newExtensionDir;
    final Path extensionsParentDir;
    final Path itTestParentDir;
    final Path bomDir;

    public CreateExtensionCommandHandler(String groupId, String artifactId, QuarkusExtensionCodestartProjectInput input, Path newExtensionDir) {
        this(groupId, artifactId, input, newExtensionDir, null, null, null);
    }

    public CreateExtensionCommandHandler(String groupId, String artifactId, QuarkusExtensionCodestartProjectInput input, Path newExtensionDir, Path extensionsParentDir, Path itTestParentDir, Path bomDir) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.input = input;
        this.newExtensionDir = newExtensionDir;
        this.extensionsParentDir = extensionsParentDir;
        this.itTestParentDir = itTestParentDir;
        this.bomDir = bomDir;
    }

    public QuarkusCommandOutcome execute(MessageWriter log) throws QuarkusCommandException {
        try {
            QuarkusExtensionCodestartCatalog catalog = QuarkusExtensionCodestartCatalog.fromBaseCodestartsResources();
            catalog.createProject(this.input).generate(this.newExtensionDir);
            String extensionDirName = this.newExtensionDir.getFileName().toString();
            if (this.extensionsParentDir != null) {
                this.updateExtensionsParentPom(extensionDirName, this.extensionsParentDir);
                log.info(MessageIcons.SUCCESS_ICON + " New extension module '%s' added to %s", new Object[]{extensionDirName, this.extensionsParentDir});
            }
            if (this.itTestParentDir != null) {
                this.updateITParentPomAndMoveDir(extensionDirName, this.newExtensionDir, this.itTestParentDir);
                log.info(MessageIcons.SUCCESS_ICON + " New integration test module '%s' added to %s", new Object[]{extensionDirName, this.itTestParentDir});
            }
            if (this.bomDir != null) {
                this.updateBom(this.groupId, this.artifactId, this.bomDir);
                log.info(MessageIcons.SUCCESS_ICON + " The extension runtime and deployment artifacts have been added to the bom dependenciesManagement: %s", new Object[]{this.bomDir});
            }
            log.info("\n-----------\n" + MessageIcons.NOOP_ICON + " extension has been successfully generated in:\n--> " + this.newExtensionDir.toString() + "\n-----------");
            return QuarkusCommandOutcome.success();
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Error while creating Quarkus extension: " + e.getMessage(), e);
        }
    }

    public Map<String, Object> getData() {
        return Collections.unmodifiableMap(this.input.getData());
    }

    private void updateBom(String groupId, String artifactId, Path bomDir) throws QuarkusCommandException {
        Path bomPom = CreateExtensionCommandHandler.checkPomExists(bomDir);
        ArrayList<PomTransformer.Transformation> transformations = new ArrayList<PomTransformer.Transformation>();
        transformations.add(PomTransformer.Transformation.addManagedDependency(groupId, artifactId, "${project.version}"));
        transformations.add(PomTransformer.Transformation.addManagedDependency(groupId, artifactId + "-deployment", "${project.version}"));
        new PomTransformer(bomPom, StandardCharsets.UTF_8).transform(transformations);
    }

    private void updateITParentPomAndMoveDir(String extensionDirName, Path newExtensionDir, Path itTestDir) throws QuarkusCommandException, IOException {
        Path itTestPom = CreateExtensionCommandHandler.checkPomExists(itTestDir);
        new PomTransformer(itTestPom, StandardCharsets.UTF_8).transform(PomTransformer.Transformation.addModule(extensionDirName));
        FileUtils.moveDirectory((File)newExtensionDir.resolve("integration-tests").toFile(), (File)itTestDir.resolve(extensionDirName).toFile());
    }

    private void updateExtensionsParentPom(String extensionDirName, Path extensionsDir) throws QuarkusCommandException {
        Path extensionsPom = CreateExtensionCommandHandler.checkPomExists(extensionsDir);
        new PomTransformer(extensionsPom, StandardCharsets.UTF_8).transform(PomTransformer.Transformation.addModule(extensionDirName));
    }

    public static Path checkPomExists(Path dir) throws QuarkusCommandException {
        Path pom = dir.resolve("pom.xml");
        if (!Files.exists(pom, new LinkOption[0])) {
            throw new QuarkusCommandException("Invalid directory structure, file not found: " + pom.toString());
        }
        return pom;
    }

    public static Model readPom(Path dir) throws QuarkusCommandException {
        Path pom = CreateExtensionCommandHandler.checkPomExists(dir);
        try {
            return MojoUtils.readPom(pom.toFile());
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Error while reading pom: " + pom.toString(), e);
        }
    }
}

