/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.RefreshToken;
import io.quarkus.oidc.UserInfo;
import io.quarkus.security.identity.SecurityIdentity;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.logging.Logger;

@RequestScoped
public class OidcTokenCredentialProducer {
    private static final Logger LOG = Logger.getLogger(OidcTokenCredentialProducer.class);
    @Inject
    SecurityIdentity identity;

    @Produces
    @RequestScoped
    IdTokenCredential currentIdToken() {
        IdTokenCredential cred = (IdTokenCredential)this.identity.getCredential(IdTokenCredential.class);
        if (cred == null || cred.getToken() == null) {
            LOG.trace((Object)"IdToken is null");
            cred = new IdTokenCredential();
        }
        return cred;
    }

    @Produces
    @RequestScoped
    AccessTokenCredential currentAccessToken() {
        AccessTokenCredential cred = (AccessTokenCredential)this.identity.getCredential(AccessTokenCredential.class);
        if (cred == null || cred.getToken() == null) {
            LOG.trace((Object)"AccessToken is null");
            cred = new AccessTokenCredential();
        }
        return cred;
    }

    @Produces
    @RequestScoped
    RefreshToken currentRefreshToken() {
        RefreshToken cred = (RefreshToken)this.identity.getCredential(RefreshToken.class);
        if (cred == null) {
            LOG.trace((Object)"RefreshToken is null");
            cred = new RefreshToken();
        }
        return cred;
    }

    @Produces
    @RequestScoped
    UserInfo currentUserInfo() {
        UserInfo userInfo = (UserInfo)this.identity.getAttribute("userinfo");
        if (userInfo == null) {
            throw new OIDCException("UserInfo can not be injected");
        }
        return userInfo;
    }
}

