/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultTenantConfigResolver {
    private static final Logger LOG = Logger.getLogger(DefaultTenantConfigResolver.class);
    private static final String CURRENT_STATIC_TENANT_ID = "static.tenant.id";
    private static final String CURRENT_STATIC_TENANT_ID_NULL = "static.tenant.id.null";
    private static final String CURRENT_DYNAMIC_TENANT_CONFIG = "dynamic.tenant.config";
    private static final String CURRENT_DYNAMIC_TENANT_CONFIG_NULL = "dynamic.tenant.config.null";
    @Inject
    Instance<TenantResolver> tenantResolver;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    @Inject
    TenantConfigBean tenantConfigBean;
    @Inject
    Instance<TokenStateManager> tokenStateManager;
    @Inject
    Event<SecurityEvent> securityEvent;
    @Inject
    @ConfigProperty(name="quarkus.http.proxy.enable-forwarded-prefix")
    boolean enableHttpForwardedPrefix;
    private volatile boolean securityEventObserved;

    @PostConstruct
    public void verifyResolvers() {
        if (this.tenantConfigResolver.isResolvable() && this.tenantConfigResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantConfigResolver.class + " beans registered");
        }
        if (this.tenantResolver.isResolvable() && this.tenantResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantResolver.class + " beans registered");
        }
        if (this.tokenStateManager.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TokenStateManager.class + " beans registered");
        }
    }

    OidcTenantConfig resolveConfig(RoutingContext context) {
        TenantConfigContext tenant;
        OidcTenantConfig tenantConfig = this.getDynamicTenantConfig(context);
        if (tenantConfig == null && (tenant = this.getStaticTenantContext(context)) != null) {
            tenantConfig = tenant.oidcConfig;
        }
        return tenantConfig;
    }

    Uni<TenantConfigContext> resolveContext(RoutingContext context) {
        Uni tenantContext = this.getDynamicTenantContext(context);
        if (tenantContext == null) {
            tenantContext = Uni.createFrom().item((Object)this.getStaticTenantContext(context));
        }
        return tenantContext;
    }

    private TenantConfigContext getStaticTenantContext(RoutingContext context) {
        TenantConfigContext configContext;
        String tenantId = null;
        if (this.tenantResolver.isResolvable() && (tenantId = (String)context.get(CURRENT_STATIC_TENANT_ID)) == null && context.get(CURRENT_STATIC_TENANT_ID_NULL) == null) {
            tenantId = ((TenantResolver)this.tenantResolver.get()).resolve(context);
            if (tenantId != null) {
                context.put(CURRENT_STATIC_TENANT_ID, (Object)tenantId);
            } else {
                context.put(CURRENT_STATIC_TENANT_ID_NULL, (Object)true);
            }
        }
        TenantConfigContext tenantConfigContext = configContext = tenantId != null ? this.tenantConfigBean.getStaticTenantsConfig().get(tenantId) : null;
        if (configContext == null) {
            if (tenantId != null && !tenantId.isEmpty()) {
                LOG.debugf("No configuration with a tenant id '%s' has been found, using the default configuration", new Object[0]);
            }
            configContext = this.tenantConfigBean.getDefaultTenant();
        }
        return configContext;
    }

    boolean isSecurityEventObserved() {
        return this.securityEventObserved;
    }

    void setSecurityEventObserved(boolean securityEventObserved) {
        this.securityEventObserved = securityEventObserved;
    }

    Event<SecurityEvent> getSecurityEvent() {
        return this.securityEvent;
    }

    TokenStateManager getTokenStateManager() {
        return (TokenStateManager)this.tokenStateManager.get();
    }

    private OidcTenantConfig getDynamicTenantConfig(RoutingContext context) {
        OidcTenantConfig oidcConfig = null;
        if (this.tenantConfigResolver.isResolvable() && (oidcConfig = (OidcTenantConfig)((Object)context.get(CURRENT_DYNAMIC_TENANT_CONFIG))) == null && context.get(CURRENT_DYNAMIC_TENANT_CONFIG_NULL) == null) {
            oidcConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context);
            if (oidcConfig != null) {
                context.put(CURRENT_DYNAMIC_TENANT_CONFIG, (Object)oidcConfig);
            } else {
                context.put(CURRENT_DYNAMIC_TENANT_CONFIG_NULL, (Object)true);
            }
        }
        return oidcConfig;
    }

    private Uni<TenantConfigContext> getDynamicTenantContext(RoutingContext context) {
        OidcTenantConfig tenantConfig = this.getDynamicTenantConfig(context);
        if (tenantConfig != null) {
            String tenantId = tenantConfig.getTenantId().orElseThrow(() -> new OIDCException("Tenant configuration must have tenant id"));
            TenantConfigContext tenantContext = this.tenantConfigBean.getDynamicTenantsConfig().get(tenantId);
            if (tenantContext == null) {
                return this.tenantConfigBean.getTenantConfigContextFactory().apply(tenantConfig);
            }
            return Uni.createFrom().item((Object)tenantContext);
        }
        return null;
    }

    boolean isEnableHttpForwardedPrefix() {
        return this.enableHttpForwardedPrefix;
    }

    public Executor getBlockingExecutor() {
        return this.tenantConfigBean.getBlockingExecutor();
    }
}

