/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.RefreshToken;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.CookieImpl;
import java.net.URI;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class CodeAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    static final String COOKIE_DELIM = "|";
    static final Pattern COOKIE_PATTERN = Pattern.compile("\\|");
    static final String SESSION_COOKIE_NAME = "q_session";
    static final String SESSION_MAX_AGE_PARAM = "session-max-age";
    private static final Logger LOG = Logger.getLogger(CodeAuthenticationMechanism.class);
    private static final String STATE_COOKIE_NAME = "q_auth";
    private static final String POST_LOGOUT_COOKIE_NAME = "q_post_logout";

    private static QuarkusSecurityIdentity augmentIdentity(final SecurityIdentity securityIdentity, String accessToken, String refreshToken, RoutingContext context) {
        IdTokenCredential idTokenCredential = (IdTokenCredential)securityIdentity.getCredential(IdTokenCredential.class);
        RefreshToken refreshTokenCredential = new RefreshToken(refreshToken);
        return QuarkusSecurityIdentity.builder().setPrincipal(securityIdentity.getPrincipal()).addCredential((Credential)idTokenCredential).addCredential((Credential)new AccessTokenCredential(accessToken, refreshTokenCredential, context)).addCredential((Credential)refreshTokenCredential).addRoles(securityIdentity.getRoles()).addAttributes(securityIdentity.getAttributes()).addPermissionChecker((Function)new Function<Permission, Uni<Boolean>>(){

            @Override
            public Uni<Boolean> apply(Permission permission) {
                return securityIdentity.checkPermission(permission);
            }
        }).build();
    }

    public Uni<SecurityIdentity> authenticate(final RoutingContext context, final IdentityProviderManager identityProviderManager) {
        final io.vertx.core.http.Cookie sessionCookie = context.request().getCookie(CodeAuthenticationMechanism.getSessionCookieName(this.resolver.resolveConfig(context)));
        if (sessionCookie != null) {
            Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
            return resolvedContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                    return CodeAuthenticationMechanism.this.reAuthenticate(sessionCookie, context, identityProviderManager, tenantContext);
                }
            });
        }
        final String code = context.request().getParam("code");
        if (code == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
        return resolvedContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                return CodeAuthenticationMechanism.this.performCodeFlow(identityProviderManager, context, tenantContext, code);
            }
        });
    }

    private Uni<SecurityIdentity> reAuthenticate(io.vertx.core.http.Cookie sessionCookie, final RoutingContext context, final IdentityProviderManager identityProviderManager, final TenantConfigContext configContext) {
        final AuthorizationCodeTokens session = this.resolver.getTokenStateManager().getTokens(context, configContext.oidcConfig, sessionCookie.getValue());
        context.put("access_token", (Object)session.getAccessToken());
        return this.authenticate(identityProviderManager, new IdTokenCredential(session.getIdToken(), context)).map((Function)new Function<SecurityIdentity, SecurityIdentity>(){

            @Override
            public SecurityIdentity apply(SecurityIdentity identity) {
                if (CodeAuthenticationMechanism.this.isLogout(context, configContext)) {
                    CodeAuthenticationMechanism.this.fireEvent(SecurityEvent.Type.OIDC_LOGOUT_RP_INITIATED, identity);
                    throw CodeAuthenticationMechanism.this.redirectToLogoutEndpoint(context, configContext, session.getIdToken());
                }
                return CodeAuthenticationMechanism.augmentIdentity(identity, session.getAccessToken(), session.getRefreshToken(), context);
            }
        }).onFailure().recoverWithUni((Function)new Function<Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<? extends SecurityIdentity> apply(Throwable throwable) {
                if (throwable instanceof AuthenticationRedirectException) {
                    throw (AuthenticationRedirectException)AuthenticationRedirectException.class.cast(throwable);
                }
                if (!(throwable instanceof TokenAutoRefreshException)) {
                    Throwable cause = throwable.getCause();
                    if (cause != null && !"expired token".equalsIgnoreCase(cause.getMessage())) {
                        LOG.debugf("Authentication failure: %s", (Object)cause);
                        throw new AuthenticationCompletionException(cause);
                    }
                    if (!configContext.oidcConfig.token.refreshExpired) {
                        LOG.debug((Object)"Token has expired, token refresh is not allowed");
                        throw new AuthenticationCompletionException(cause);
                    }
                    LOG.debug((Object)"Token has expired, trying to refresh it");
                    return CodeAuthenticationMechanism.this.refreshSecurityIdentity(configContext, session.getRefreshToken(), context, identityProviderManager, false, null);
                }
                return CodeAuthenticationMechanism.this.refreshSecurityIdentity(configContext, session.getRefreshToken(), context, identityProviderManager, true, ((TokenAutoRefreshException)throwable).getSecurityIdentity());
            }
        });
    }

    private boolean isJavaScript(RoutingContext context) {
        String value = context.request().getHeader("X-Requested-With");
        return "JavaScript".equals(value) || "XMLHttpRequest".equals(value);
    }

    private boolean shouldAutoRedirect(TenantConfigContext configContext, RoutingContext context) {
        return this.isJavaScript(context) ? configContext.oidcConfig.authentication.javaScriptAutoRedirect : true;
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext context) {
        Uni<TenantConfigContext> tenantContext = this.resolver.resolveContext(context);
        return tenantContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(TenantConfigContext tenantContext) {
                return CodeAuthenticationMechanism.this.getChallengeInternal(context, tenantContext);
            }
        });
    }

    public Uni<ChallengeData> getChallengeInternal(RoutingContext context, TenantConfigContext configContext) {
        this.removeCookie(context, configContext, CodeAuthenticationMechanism.getSessionCookieName(configContext.oidcConfig));
        if (!this.shouldAutoRedirect(configContext, context)) {
            return Uni.createFrom().item((Object)new ChallengeData(499, (CharSequence)"WWW-Authenticate", "OIDC"));
        }
        JsonObject params = new JsonObject();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        configContext.oidcConfig.getAuthentication().scopes.ifPresent(scopes::addAll);
        params.put("scopes", new JsonArray(scopes));
        String redirectPath = this.getRedirectPath(configContext, context);
        String redirectUriParam = this.buildUri(context, this.isForceHttps(configContext), redirectPath);
        LOG.debugf("Authentication request redirect_uri parameter: %s", (Object)redirectUriParam);
        params.put("redirect_uri", redirectUriParam);
        params.put("state", this.generateCodeFlowState(context, configContext, redirectPath));
        if (configContext.oidcConfig.authentication.getExtraParams() != null) {
            for (Map.Entry<String, String> entry : configContext.oidcConfig.authentication.getExtraParams().entrySet()) {
                params.put(entry.getKey(), entry.getValue());
            }
        }
        return Uni.createFrom().item((Object)new ChallengeData(HttpResponseStatus.FOUND.code(), HttpHeaders.LOCATION, configContext.auth.authorizeURL(params)));
    }

    private Uni<SecurityIdentity> performCodeFlow(final IdentityProviderManager identityProviderManager, final RoutingContext context, final TenantConfigContext configContext, String code) {
        context.put("new_authentication", (Object)Boolean.TRUE);
        Cookie stateCookie = context.getCookie(CodeAuthenticationMechanism.getStateCookieName(configContext));
        String userPath = null;
        String userQuery = null;
        if (stateCookie != null) {
            List values = context.queryParam("state");
            if (values.size() != 1) {
                LOG.debug((Object)"State parameter can not be empty or multi-valued");
                return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
            }
            if (!stateCookie.getValue().startsWith((String)values.get(0))) {
                LOG.debug((Object)"State cookie value does not match the state query parameter value");
                return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
            }
            String[] pair = COOKIE_PATTERN.split(stateCookie.getValue());
            if (pair.length == 2) {
                int userQueryIndex = pair[1].indexOf("?");
                if (userQueryIndex >= 0) {
                    userPath = pair[1].substring(0, userQueryIndex);
                    if (userQueryIndex + 1 < pair[1].length()) {
                        userQuery = pair[1].substring(userQueryIndex + 1);
                    }
                } else {
                    userPath = pair[1];
                }
            }
        } else {
            LOG.debug((Object)"The state cookie is missing after a redirect from IDP, authentication has failed");
            return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
        }
        this.removeCookie(context, configContext, CodeAuthenticationMechanism.getStateCookieName(configContext));
        final JsonObject params = new JsonObject();
        params.put("code", code);
        String redirectPath = this.getRedirectPath(configContext, context);
        String redirectUriParam = this.buildUri(context, this.isForceHttps(configContext), redirectPath);
        LOG.debugf("Token request redirect_uri parameter: %s", (Object)redirectUriParam);
        params.put("redirect_uri", redirectUriParam);
        OidcCommonConfig.Credentials creds = configContext.oidcConfig.getCredentials();
        if (OidcCommonUtils.isClientSecretPostAuthRequired((OidcCommonConfig.Credentials)creds)) {
            params.put("client_secret", (String)creds.clientSecret.value.get());
        } else if (creds.jwt.secret.isPresent()) {
            params.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            params.put("client_assertion", OidcCommonUtils.signJwt((OidcCommonConfig)configContext.oidcConfig));
        }
        final String finalUserPath = userPath;
        final String finalUserQuery = userQuery;
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

            @Override
            public void accept(final UniEmitter<? super SecurityIdentity> uniEmitter) {
                configContext.auth.authenticate(params, userAsyncResult -> {
                    if (userAsyncResult.failed()) {
                        if (userAsyncResult.cause() != null) {
                            LOG.debugf("Exception during the code to token exchange: %s", (Object)userAsyncResult.cause().getMessage());
                        }
                        uniEmitter.fail((Throwable)new AuthenticationCompletionException(userAsyncResult.cause()));
                    } else {
                        final AccessToken authResult = (AccessToken)AccessToken.class.cast(userAsyncResult.result());
                        final String opaqueIdToken = authResult.opaqueIdToken();
                        final String opaqueAccessToken = authResult.opaqueAccessToken();
                        final String opaqueRefreshToken = authResult.opaqueRefreshToken();
                        context.put("access_token", (Object)opaqueAccessToken);
                        CodeAuthenticationMechanism.this.authenticate(identityProviderManager, new IdTokenCredential(opaqueIdToken, context)).subscribe().with((Consumer)new Consumer<SecurityIdentity>(){

                            @Override
                            public void accept(SecurityIdentity identity) {
                                CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, authResult.idToken(), opaqueIdToken, opaqueAccessToken, opaqueRefreshToken, identity);
                                boolean removeRedirectParams = configContext.oidcConfig.authentication.isRemoveRedirectParameters();
                                if (removeRedirectParams || finalUserPath != null || finalUserQuery != null) {
                                    URI absoluteUri = URI.create(context.request().absoluteURI());
                                    StringBuilder finalUriWithoutQuery = new StringBuilder(CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(configContext), absoluteUri.getAuthority(), finalUserPath != null ? finalUserPath : absoluteUri.getRawPath()));
                                    if (!removeRedirectParams) {
                                        finalUriWithoutQuery.append('?').append(absoluteUri.getRawQuery());
                                    }
                                    if (finalUserQuery != null) {
                                        finalUriWithoutQuery.append(!removeRedirectParams ? "" : "?");
                                        finalUriWithoutQuery.append(finalUserQuery);
                                    }
                                    String finalRedirectUri = finalUriWithoutQuery.toString();
                                    LOG.debugf("Final redirect URI: %s", (Object)finalRedirectUri);
                                    uniEmitter.fail((Throwable)new AuthenticationRedirectException(finalRedirectUri));
                                } else {
                                    uniEmitter.complete((Object)CodeAuthenticationMechanism.augmentIdentity(identity, opaqueAccessToken, opaqueRefreshToken, context));
                                }
                            }
                        }, (Consumer)new Consumer<Throwable>(){

                            @Override
                            public void accept(Throwable throwable) {
                                uniEmitter.fail(throwable);
                            }
                        });
                    }
                });
            }
        });
    }

    private void processSuccessfulAuthentication(RoutingContext context, TenantConfigContext configContext, JsonObject idToken, String opaqueIdToken, String opaqueAccessToken, String opaqueRefreshToken, SecurityIdentity securityIdentity) {
        this.removeCookie(context, configContext, CodeAuthenticationMechanism.getSessionCookieName(configContext.oidcConfig));
        if (idToken == null) {
            idToken = OidcUtils.decodeJwtContent(opaqueIdToken);
        }
        if (!idToken.containsKey("exp") || !idToken.containsKey("iat")) {
            LOG.debug((Object)"ID Token is required to contain 'exp' and 'iat' claims");
            throw new AuthenticationCompletionException();
        }
        long maxAge = idToken.getLong("exp") - idToken.getLong("iat");
        if (configContext.oidcConfig.token.lifespanGrace.isPresent()) {
            maxAge += (long)configContext.oidcConfig.token.lifespanGrace.getAsInt();
        }
        if (configContext.oidcConfig.token.refreshExpired) {
            maxAge += configContext.oidcConfig.authentication.sessionAgeExtension.getSeconds();
        }
        context.put(SESSION_MAX_AGE_PARAM, (Object)maxAge);
        String cookieValue = this.resolver.getTokenStateManager().createTokenState(context, configContext.oidcConfig, new AuthorizationCodeTokens(opaqueIdToken, opaqueAccessToken, opaqueRefreshToken));
        CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getSessionCookieName(configContext.oidcConfig), cookieValue, maxAge);
        this.fireEvent(SecurityEvent.Type.OIDC_LOGIN, securityIdentity);
    }

    private void fireEvent(SecurityEvent.Type eventType, SecurityIdentity securityIdentity) {
        if (this.resolver.isSecurityEventObserved()) {
            this.resolver.getSecurityEvent().fire((Object)new SecurityEvent(eventType, securityIdentity));
        }
    }

    private String getRedirectPath(TenantConfigContext configContext, RoutingContext context) {
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        return auth.getRedirectPath().isPresent() ? auth.getRedirectPath().get() : context.request().path();
    }

    private String generateCodeFlowState(RoutingContext context, TenantConfigContext configContext, String redirectPath) {
        String uuid;
        String cookieValue = uuid = UUID.randomUUID().toString();
        OidcTenantConfig.Authentication auth = configContext.oidcConfig.getAuthentication();
        if (auth.isRestorePathAfterRedirect()) {
            String requestPath;
            String requestQuery = context.request().query();
            String string = requestPath = !redirectPath.equals(context.request().path()) || requestQuery != null ? context.request().path() : "";
            if (requestQuery != null) {
                requestPath = requestPath + "?" + requestQuery;
            }
            if (!requestPath.isEmpty()) {
                cookieValue = cookieValue + COOKIE_DELIM + requestPath;
            }
        }
        CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getStateCookieName(configContext), cookieValue, 1800L);
        return uuid;
    }

    private String generatePostLogoutState(RoutingContext context, TenantConfigContext configContext) {
        this.removeCookie(context, configContext, CodeAuthenticationMechanism.getPostLogoutCookieName(configContext));
        return CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getPostLogoutCookieName(configContext), UUID.randomUUID().toString(), 1800L).getValue();
    }

    static CookieImpl createCookie(RoutingContext context, OidcTenantConfig oidcConfig, String name, String value, long maxAge) {
        CookieImpl cookie = new CookieImpl(name, value);
        cookie.setHttpOnly(true);
        cookie.setSecure(oidcConfig.authentication.cookieForceSecure || context.request().isSSL());
        cookie.setMaxAge(maxAge);
        LOG.debugf(name + " cookie 'max-age' parameter is set to %d", maxAge);
        OidcTenantConfig.Authentication auth = oidcConfig.getAuthentication();
        if (auth.cookiePath.isPresent()) {
            cookie.setPath(auth.getCookiePath().get());
        }
        if (auth.cookieDomain.isPresent()) {
            cookie.setDomain(auth.getCookieDomain().get());
        }
        context.response().addCookie((io.vertx.core.http.Cookie)cookie);
        return cookie;
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String path) {
        String authority = URI.create(context.request().absoluteURI()).getAuthority();
        return this.buildUri(context, forceHttps, authority, path);
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String authority, String path) {
        String forwardedPrefixHeader;
        String scheme = forceHttps ? "https" : context.request().scheme();
        String forwardedPrefix = "";
        if (this.resolver.isEnableHttpForwardedPrefix() && (forwardedPrefixHeader = context.request().getHeader("X-Forwarded-Prefix")) != null && !forwardedPrefixHeader.equals("/") && !forwardedPrefixHeader.equals("//") && (forwardedPrefix = forwardedPrefixHeader).endsWith("/")) {
            forwardedPrefix = forwardedPrefix.substring(0, forwardedPrefix.length() - 1);
        }
        return scheme + "://" + authority + forwardedPrefix + path;
    }

    private void removeCookie(RoutingContext context, TenantConfigContext configContext, String cookieName) {
        ServerCookie cookie = (ServerCookie)context.cookieMap().get(cookieName);
        if (cookie != null) {
            if (SESSION_COOKIE_NAME.equals(cookieName)) {
                this.resolver.getTokenStateManager().deleteTokens(context, configContext.oidcConfig, cookie.getValue());
            }
            CodeAuthenticationMechanism.removeCookie(cookie, configContext.oidcConfig);
        }
    }

    static void removeCookie(ServerCookie cookie, OidcTenantConfig oidcConfig) {
        if (cookie != null) {
            cookie.setValue("");
            cookie.setMaxAge(0L);
            OidcTenantConfig.Authentication auth = oidcConfig.getAuthentication();
            if (auth.cookiePath.isPresent()) {
                cookie.setPath(auth.cookiePath.get());
            }
            if (auth.cookieDomain.isPresent()) {
                cookie.setDomain(auth.cookieDomain.get());
            }
        }
    }

    private boolean isLogout(RoutingContext context, TenantConfigContext configContext) {
        Optional<String> logoutPath = configContext.oidcConfig.logout.path;
        if (logoutPath.isPresent()) {
            return context.request().absoluteURI().equals(this.buildUri(context, false, logoutPath.get()));
        }
        return false;
    }

    private Uni<SecurityIdentity> refreshSecurityIdentity(final TenantConfigContext configContext, final String refreshToken, final RoutingContext context, final IdentityProviderManager identityProviderManager, final boolean autoRefresh, SecurityIdentity fallback) {
        Uni<OAuth2TokenImpl> refreshedTokensUni = this.trySilentRefreshUni(configContext, refreshToken);
        return refreshedTokensUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<OAuth2TokenImpl, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final OAuth2TokenImpl token, final Throwable t) {
                return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

                    @Override
                    public void accept(final UniEmitter<? super SecurityIdentity> emitter) {
                        if (t != null) {
                            LOG.debugf("ID token refresh has failed: %s", (Object)t.getMessage());
                            if (autoRefresh) {
                                LOG.debug((Object)"Using the current SecurityIdentity since the ID token is still valid");
                                emitter.complete((Object)((TokenAutoRefreshException)t).getSecurityIdentity());
                            } else {
                                emitter.fail((Throwable)new AuthenticationFailedException(t));
                            }
                        } else {
                            final String opaqueIdToken = token.opaqueIdToken();
                            final String opaqueAccessToken = token.opaqueAccessToken();
                            final String opaqueRefreshToken = token.opaqueRefreshToken();
                            context.put("access_token", (Object)token.opaqueAccessToken());
                            context.put("refresh_token_grant_response", (Object)Boolean.TRUE);
                            CodeAuthenticationMechanism.this.authenticate(identityProviderManager, new IdTokenCredential(token.opaqueIdToken(), context)).subscribe().with((Consumer)new Consumer<SecurityIdentity>(){

                                @Override
                                public void accept(SecurityIdentity identity) {
                                    String refresh = opaqueRefreshToken != null ? opaqueRefreshToken : refreshToken;
                                    CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, token.idToken(), opaqueIdToken, opaqueAccessToken, refresh, identity);
                                    QuarkusSecurityIdentity newSecurityIdentity = CodeAuthenticationMechanism.augmentIdentity(identity, opaqueAccessToken, refresh, context);
                                    CodeAuthenticationMechanism.this.fireEvent(autoRefresh ? SecurityEvent.Type.OIDC_SESSION_REFRESHED : SecurityEvent.Type.OIDC_SESSION_EXPIRED_AND_REFRESHED, (SecurityIdentity)newSecurityIdentity);
                                    emitter.complete((Object)newSecurityIdentity);
                                }
                            }, (Consumer)new Consumer<Throwable>(){

                                @Override
                                public void accept(Throwable throwable) {
                                    emitter.fail((Throwable)new AuthenticationFailedException(throwable));
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private Uni<OAuth2TokenImpl> trySilentRefreshUni(final TenantConfigContext configContext, final String refreshToken) {
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super OAuth2TokenImpl>>(){

            @Override
            public void accept(final UniEmitter<? super OAuth2TokenImpl> emitter) {
                if (BlockingOperationControl.isBlockingAllowed()) {
                    CodeAuthenticationMechanism.this.trySilentRefresh((UniEmitter<? super OAuth2TokenImpl>)emitter, configContext, refreshToken);
                } else {
                    CodeAuthenticationMechanism.this.resolver.getBlockingExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            CodeAuthenticationMechanism.this.trySilentRefresh((UniEmitter<? super OAuth2TokenImpl>)emitter, configContext, refreshToken);
                        }
                    });
                }
            }
        });
    }

    private void trySilentRefresh(final UniEmitter<? super OAuth2TokenImpl> emitter, TenantConfigContext configContext, String refreshToken) {
        final OAuth2TokenImpl token = new OAuth2TokenImpl(configContext.auth, new JsonObject());
        token.principal().put("refresh_token", refreshToken);
        token.refresh((Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.succeeded()) {
                    emitter.complete((Object)token);
                } else {
                    emitter.fail((Throwable)new AuthenticationFailedException(result.cause()));
                }
            }
        });
    }

    private String buildLogoutRedirectUri(TenantConfigContext configContext, String idToken, RoutingContext context) {
        String logoutPath = configContext.oidcConfig.getEndSessionPath().orElse(((OAuth2AuthProviderImpl)OAuth2AuthProviderImpl.class.cast(configContext.auth)).getConfig().getLogoutPath());
        StringBuilder logoutUri = new StringBuilder(logoutPath).append("?").append("id_token_hint=").append(idToken);
        if (configContext.oidcConfig.logout.postLogoutPath.isPresent()) {
            logoutUri.append("&post_logout_redirect_uri=").append(this.buildUri(context, this.isForceHttps(configContext), configContext.oidcConfig.logout.postLogoutPath.get()));
            logoutUri.append("&state=").append(this.generatePostLogoutState(context, configContext));
        }
        return logoutUri.toString();
    }

    private boolean isForceHttps(TenantConfigContext configContext) {
        return configContext.oidcConfig.authentication.forceRedirectHttpsScheme;
    }

    private AuthenticationRedirectException redirectToLogoutEndpoint(RoutingContext context, TenantConfigContext configContext, String idToken) {
        this.removeCookie(context, configContext, CodeAuthenticationMechanism.getSessionCookieName(configContext.oidcConfig));
        return new AuthenticationRedirectException(this.buildLogoutRedirectUri(configContext, idToken, context));
    }

    private static String getStateCookieName(TenantConfigContext configContext) {
        String cookieSuffix = CodeAuthenticationMechanism.getCookieSuffix(configContext.oidcConfig.tenantId.get());
        return STATE_COOKIE_NAME + cookieSuffix;
    }

    private static String getPostLogoutCookieName(TenantConfigContext configContext) {
        String cookieSuffix = CodeAuthenticationMechanism.getCookieSuffix(configContext.oidcConfig.tenantId.get());
        return POST_LOGOUT_COOKIE_NAME + cookieSuffix;
    }

    private static String getSessionCookieName(OidcTenantConfig oidcConfig) {
        String cookieSuffix = CodeAuthenticationMechanism.getCookieSuffix(oidcConfig.tenantId.get());
        return SESSION_COOKIE_NAME + cookieSuffix;
    }

    static String getCookieSuffix(String tenantId) {
        return !"Default".equals(tenantId) ? "_" + tenantId : "";
    }
}

