/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcRuntimeClient;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class OidcRecorder {
    private static final Logger LOG = Logger.getLogger(OidcRecorder.class);
    private static final String DEFAULT_TENANT_ID = "Default";
    private static final Map<String, TenantConfigContext> dynamicTenantsConfig = new ConcurrentHashMap<String, TenantConfigContext>();

    public Supplier<TenantConfigBean> setup(OidcConfig config, Supplier<Vertx> vertx, final TlsConfig tlsConfig) {
        final Vertx vertxValue = vertx.get();
        String defaultTenantId = config.defaultTenant.getTenantId().orElse(DEFAULT_TENANT_ID);
        final TenantConfigContext defaultTenantContext = this.createTenantContext(vertxValue, config.defaultTenant, tlsConfig, defaultTenantId);
        final HashMap<String, TenantConfigContext> staticTenantsConfig = new HashMap<String, TenantConfigContext>();
        for (Map.Entry<String, OidcTenantConfig> tenant : config.namedTenants.entrySet()) {
            OidcCommonUtils.verifyConfigurationId((String)defaultTenantId, (String)tenant.getKey(), tenant.getValue().getTenantId());
            staticTenantsConfig.put(tenant.getKey(), this.createTenantContext(vertxValue, tenant.getValue(), tlsConfig, tenant.getKey()));
        }
        return new Supplier<TenantConfigBean>(){

            @Override
            public TenantConfigBean get() {
                return new TenantConfigBean(staticTenantsConfig, dynamicTenantsConfig, defaultTenantContext, new Function<OidcTenantConfig, Uni<TenantConfigContext>>(){

                    @Override
                    public Uni<TenantConfigContext> apply(final OidcTenantConfig config) {
                        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super TenantConfigContext>>(){

                            @Override
                            public void accept(final UniEmitter<? super TenantConfigContext> uniEmitter) {
                                if (BlockingOperationControl.isBlockingAllowed()) {
                                    OidcRecorder.this.createDynamicTenantContext((UniEmitter<? super TenantConfigContext>)uniEmitter, vertxValue, config, tlsConfig, config.getTenantId().get());
                                } else {
                                    ExecutorRecorder.getCurrent().execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            OidcRecorder.this.createDynamicTenantContext((UniEmitter<? super TenantConfigContext>)uniEmitter, vertxValue, config, tlsConfig, config.getTenantId().get());
                                        }
                                    });
                                }
                            }
                        });
                    }
                }, ExecutorRecorder.getCurrent());
            }
        };
    }

    private void createDynamicTenantContext(UniEmitter<? super TenantConfigContext> uniEmitter, Vertx vertx, OidcTenantConfig oidcConfig, TlsConfig tlsConfig, String tenantId) {
        try {
            if (!dynamicTenantsConfig.containsKey(tenantId)) {
                dynamicTenantsConfig.putIfAbsent(tenantId, this.createTenantContext(vertx, oidcConfig, tlsConfig, tenantId));
            }
            uniEmitter.complete((Object)dynamicTenantsConfig.get(tenantId));
        }
        catch (Throwable t) {
            uniEmitter.fail(t);
        }
    }

    private TenantConfigContext createTenantContext(Vertx vertx, OidcTenantConfig oidcConfig, TlsConfig tlsConfig, String tenantId) {
        OidcCommonConfig.Credentials creds;
        if (!oidcConfig.tenantId.isPresent()) {
            oidcConfig.tenantId = Optional.of(tenantId);
        }
        if (!oidcConfig.tenantEnabled) {
            LOG.debugf("'%s' tenant configuration is disabled", (Object)tenantId);
            return new TenantConfigContext(new OidcRuntimeClient(null), oidcConfig);
        }
        OAuth2ClientOptions options = new OAuth2ClientOptions();
        if (oidcConfig.getClientId().isPresent()) {
            options.setClientID((String)oidcConfig.getClientId().get());
        }
        if (oidcConfig.getToken().issuer.isPresent()) {
            options.setValidateIssuer(false);
        }
        if (oidcConfig.getToken().getLifespanGrace().isPresent()) {
            io.vertx.ext.jwt.JWTOptions jwtOptions = new io.vertx.ext.jwt.JWTOptions();
            jwtOptions.setLeeway(oidcConfig.getToken().getLifespanGrace().getAsInt());
            options.setJWTOptions((JWTOptions)jwtOptions);
        }
        if (oidcConfig.getPublicKey().isPresent()) {
            return OidcRecorder.createdTenantContextFromPublicKey(options, oidcConfig);
        }
        OidcCommonUtils.verifyCommonConfiguration((OidcCommonConfig)oidcConfig);
        String authServerUrl = OidcCommonUtils.getAuthServerUrl((OidcCommonConfig)oidcConfig);
        options.setSite(authServerUrl);
        if (!oidcConfig.discoveryEnabled) {
            if (oidcConfig.applicationType != OidcTenantConfig.ApplicationType.SERVICE) {
                if (!oidcConfig.authorizationPath.isPresent() || !oidcConfig.tokenPath.isPresent()) {
                    throw new OIDCException("'web-app' applications must have 'authorization-path' and 'token-path' properties set when the discovery is disabled.");
                }
                options.setAuthorizationPath(OidcCommonUtils.getOidcEndpointUrl((String)authServerUrl, oidcConfig.authorizationPath));
                options.setTokenPath(OidcCommonUtils.getOidcEndpointUrl((String)authServerUrl, (Optional)oidcConfig.tokenPath));
            }
            if (oidcConfig.getUserInfoPath().isPresent()) {
                options.setUserInfoPath(OidcCommonUtils.getOidcEndpointUrl((String)authServerUrl, oidcConfig.userInfoPath));
            }
            if (!oidcConfig.jwksPath.isPresent() && !oidcConfig.introspectionPath.isPresent()) {
                throw new OIDCException("Either 'jwks-path' or 'introspection-path' properties must be set when the discovery is disabled.");
            }
            if (oidcConfig.getIntrospectionPath().isPresent()) {
                options.setIntrospectionPath(OidcCommonUtils.getOidcEndpointUrl((String)authServerUrl, oidcConfig.introspectionPath));
            }
            if (oidcConfig.getJwksPath().isPresent()) {
                options.setJwkPath(OidcCommonUtils.getOidcEndpointUrl((String)authServerUrl, oidcConfig.jwksPath));
            }
        }
        if (OidcTenantConfig.ApplicationType.SERVICE.equals((Object)oidcConfig.applicationType)) {
            if (oidcConfig.token.refreshExpired) {
                throw new ConfigurationException("The 'token.refresh-expired' property can only be enabled for " + (Object)((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
            if (oidcConfig.logout.path.isPresent()) {
                throw new ConfigurationException("The 'logout.path' property can only be enabled for " + (Object)((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
            if (oidcConfig.roles.source.isPresent() && oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.idtoken) {
                throw new ConfigurationException("The 'roles.source' property can only be set to 'idtoken' for " + (Object)((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
        }
        if (oidcConfig.tokenStateManager.strategy != OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            if (oidcConfig.authentication.userInfoRequired || oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.userinfo) {
                throw new ConfigurationException("UserInfo is required but DefaultTokenStateManager is configured to not keep the access token");
            }
            if (oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken) {
                throw new ConfigurationException("Access token is required to check the roles but DefaultTokenStateManager is configured to not keep the access token");
            }
        }
        if (OidcCommonUtils.isClientSecretBasicAuthRequired((OidcCommonConfig.Credentials)(creds = oidcConfig.getCredentials()))) {
            options.setClientSecret(OidcCommonUtils.clientSecret((OidcCommonConfig.Credentials)creds));
        } else {
            options.setClientSecretParameterName(null);
        }
        OidcCommonUtils.setHttpClientOptions((OidcCommonConfig)oidcConfig, (TlsConfig)tlsConfig, (HttpClientOptions)options);
        long connectionRetryCount = OidcCommonUtils.getConnectionRetryCount((OidcCommonConfig)oidcConfig);
        if (connectionRetryCount > 1L) {
            LOG.infof("Connecting to IDP for up to %d times every 2 seconds", (Object)connectionRetryCount);
        }
        OidcRuntimeClient client = null;
        for (long i = 0L; i < connectionRetryCount; ++i) {
            try {
                if (oidcConfig.discoveryEnabled) {
                    client = OidcRuntimeClient.discoverOidcEndpoints(vertx, options, oidcConfig);
                    break;
                }
                client = OidcRuntimeClient.setOidcEndpoints(vertx, options, oidcConfig);
                break;
            }
            catch (Throwable throwable) {
                while (throwable instanceof CompletionException && throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof OIDCException) {
                    if (i + 1L < connectionRetryCount) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw (OIDCException)throwable;
                }
                throw new OIDCException(throwable);
            }
        }
        if (oidcConfig.logout.path.isPresent() && !oidcConfig.endSessionPath.isPresent() && client.getLogoutPath() == null) {
            throw new RuntimeException("The application supports RP-Initiated Logout but the OpenID Provider does not advertise the end_session_endpoint");
        }
        return new TenantConfigContext(client, oidcConfig);
    }

    private static TenantConfigContext createdTenantContextFromPublicKey(OAuth2ClientOptions options, OidcTenantConfig oidcConfig) {
        if (oidcConfig.applicationType != OidcTenantConfig.ApplicationType.SERVICE) {
            throw new ConfigurationException("'public-key' property can only be used with the 'service' applications");
        }
        LOG.debug((Object)"'public-key' property for the local token verification is set, no connection to the OIDC server will be created");
        return new TenantConfigContext(OidcRuntimeClient.createClientWithPublicKey(options, oidcConfig.publicKey.get()), oidcConfig);
    }

    public void setSecurityEventObserved(boolean isSecurityEventObserved) {
        DefaultTenantConfigResolver bean = (DefaultTenantConfigResolver)Arc.container().instance(DefaultTenantConfigResolver.class, new Annotation[0]).get();
        bean.setSecurityEventObserved(isSecurityEventObserved);
    }

    public static Optional<ProxyOptions> toProxyOptions(OidcCommonConfig.Proxy proxyConfig) {
        return OidcCommonUtils.toProxyOptions((OidcCommonConfig.Proxy)proxyConfig);
    }
}

