/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class DefaultTenantConfigResolver {
    @Inject
    Instance<TenantResolver> tenantResolver;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    private Map<String, TenantConfigContext> tenantsConfig;
    private TenantConfigContext defaultTenant;
    private Function<OidcTenantConfig, TenantConfigContext> tenantConfigContextFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TenantConfigContext resolve(RoutingContext context) {
        OidcTenantConfig tenantConfig;
        if (this.tenantConfigResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantConfigResolver.class + " beans registered");
        }
        if (this.tenantConfigResolver.isResolvable() && (tenantConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context)) != null) {
            String tenantId = tenantConfig.getClientId().orElseThrow(() -> new IllegalStateException("You must provide a client_id"));
            TenantConfigContext tenantContext = this.tenantsConfig.get(tenantId);
            if (tenantContext == null) {
                DefaultTenantConfigResolver defaultTenantConfigResolver = this;
                synchronized (defaultTenantConfigResolver) {
                    return this.tenantsConfig.computeIfAbsent(tenantId, clientId -> this.tenantConfigContextFactory.apply(tenantConfig));
                }
            }
            return tenantContext;
        }
        String tenant = null;
        if (this.tenantResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantResolver.class + " beans registered");
        }
        if (this.tenantResolver.isResolvable()) {
            tenant = ((TenantResolver)this.tenantResolver.get()).resolve(context);
        }
        return this.tenantsConfig.getOrDefault(tenant, this.defaultTenant);
    }

    void setTenantsConfig(Map<String, TenantConfigContext> tenantsConfig) {
        this.tenantsConfig = tenantsConfig;
    }

    void setDefaultTenant(TenantConfigContext defaultTenant) {
        this.defaultTenant = defaultTenant;
    }

    void setTenantConfigContextFactory(Function<OidcTenantConfig, TenantConfigContext> tenantConfigContextFactory) {
        this.tenantConfigContextFactory = tenantConfigContextFactory;
    }
}

