/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class DefaultTenantConfigResolver {
    private static final String CURRENT_TENANT_CONFIG = "io.quarkus.oidc.current.tenant.config";
    @Inject
    Instance<TenantResolver> tenantResolver;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    private volatile Map<String, TenantConfigContext> tenantsConfig;
    private volatile TenantConfigContext defaultTenant;
    private volatile Function<OidcTenantConfig, TenantConfigContext> tenantConfigContextFactory;

    TenantConfigContext resolve(RoutingContext context) {
        if (this.tenantConfigResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantConfigResolver.class + " beans registered");
        }
        TenantConfigContext config = this.getTenantConfigFromConfigResolver(context, true);
        if (config != null) {
            return config;
        }
        String tenant = null;
        if (this.tenantResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantResolver.class + " beans registered");
        }
        if (this.tenantResolver.isResolvable()) {
            tenant = ((TenantResolver)this.tenantResolver.get()).resolve(context);
        }
        return this.tenantsConfig.getOrDefault(tenant, this.defaultTenant);
    }

    void setTenantsConfig(Map<String, TenantConfigContext> tenantsConfig) {
        this.tenantsConfig = tenantsConfig;
    }

    void setDefaultTenant(TenantConfigContext defaultTenant) {
        this.defaultTenant = defaultTenant;
    }

    void setTenantConfigContextFactory(Function<OidcTenantConfig, TenantConfigContext> tenantConfigContextFactory) {
        this.tenantConfigContextFactory = tenantConfigContextFactory;
    }

    boolean isBlocking(RoutingContext context) {
        return this.getTenantConfigFromConfigResolver(context, false) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TenantConfigContext getTenantConfigFromConfigResolver(RoutingContext context, boolean create) {
        if (this.tenantConfigResolver.isResolvable()) {
            OidcTenantConfig tenantConfig;
            if (context.get(CURRENT_TENANT_CONFIG) != null) {
                tenantConfig = (OidcTenantConfig)context.get(CURRENT_TENANT_CONFIG);
            } else {
                tenantConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context);
                context.put(CURRENT_TENANT_CONFIG, (Object)tenantConfig);
            }
            if (tenantConfig != null) {
                String tenantId = tenantConfig.getClientId().orElseThrow(() -> new IllegalStateException("You must provide a client_id"));
                TenantConfigContext tenantContext = this.tenantsConfig.get(tenantId);
                if (tenantContext == null && create) {
                    DefaultTenantConfigResolver defaultTenantConfigResolver = this;
                    synchronized (defaultTenantConfigResolver) {
                        return this.tenantsConfig.computeIfAbsent(tenantId, clientId -> this.tenantConfigContextFactory.apply(tenantConfig));
                    }
                }
                return tenantContext;
            }
        }
        return null;
    }
}

