/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.vertx.core.Handler;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import java.time.Duration;
import org.jboss.logging.Logger;

public class JwkSetRefreshHandler
implements Handler<String> {
    private static final Logger LOG = Logger.getLogger(JwkSetRefreshHandler.class);
    private OAuth2Auth auth;
    private volatile long lastForcedRefreshTime;
    private long forcedJwksRefreshIntervalMilliSecs;

    public JwkSetRefreshHandler(OAuth2Auth auth, Duration forcedJwksRefreshInterval) {
        this.auth = auth;
        this.forcedJwksRefreshIntervalMilliSecs = forcedJwksRefreshInterval.toMillis();
    }

    public void handle(String kid) {
        long now = System.currentTimeMillis();
        if (now > this.lastForcedRefreshTime + this.forcedJwksRefreshIntervalMilliSecs) {
            this.lastForcedRefreshTime = now;
            LOG.debugf("No JWK with %s key id is available, trying to refresh the JWK set", (Object)kid);
            this.auth.loadJWK(res -> {
                if (res.failed()) {
                    LOG.debugf("Failed to refresh the JWK set: %s", (Object)res.cause());
                }
            });
        }
    }
}

