/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.runtime.OidcJwtCallerPrincipal;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;

public final class OidcUtils {
    public static final String CONFIG_METADATA_ATTRIBUTE = "configuration-metadata";
    public static final String USER_INFO_ATTRIBUTE = "userinfo";
    public static final String TENANT_ID_ATTRIBUTE = "tenant-id";
    private static final Pattern CLAIM_PATH_PATTERN = Pattern.compile("\\/(?=(?:(?:[^\"]*\"){2})*[^\"]*$)");

    private OidcUtils() {
    }

    public static boolean isOpaqueToken(String token) {
        return new StringTokenizer(token, ".").countTokens() != 3;
    }

    public static JsonObject decodeJwtContent(String jwt) {
        StringTokenizer tokens = new StringTokenizer(jwt, ".");
        tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            return null;
        }
        String encodedContent = tokens.nextToken();
        if (tokens.countTokens() != 1) {
            return null;
        }
        try {
            return new JsonObject(new String(Base64.getUrlDecoder().decode(encodedContent), StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static List<String> findRoles(String clientId, OidcTenantConfig.Roles rolesConfig, JsonObject json) {
        if (rolesConfig.getRoleClaimPath().isPresent()) {
            return OidcUtils.findClaimWithRoles(rolesConfig, rolesConfig.getRoleClaimPath().get(), json, true);
        }
        List<String> groups = OidcUtils.findClaimWithRoles(rolesConfig, Claims.groups.name(), json, false);
        if (!groups.isEmpty()) {
            return groups;
        }
        LinkedList<String> allRoles = new LinkedList<String>();
        allRoles.addAll(OidcUtils.findClaimWithRoles(rolesConfig, "realm_access/roles", json, false));
        if (clientId != null) {
            allRoles.addAll(OidcUtils.findClaimWithRoles(rolesConfig, "resource_access/" + clientId + "/roles", json, false));
        }
        return allRoles;
    }

    private static List<String> findClaimWithRoles(OidcTenantConfig.Roles rolesConfig, String claimPath, JsonObject json, boolean mustExist) {
        Object claimValue = OidcUtils.findClaimValue(claimPath, json, OidcUtils.splitClaimPath(claimPath), 0, mustExist);
        if (claimValue instanceof JsonArray) {
            return OidcUtils.convertJsonArrayToList((JsonArray)claimValue);
        }
        if (claimValue != null) {
            String sep = rolesConfig.getRoleClaimSeparator().isPresent() ? rolesConfig.getRoleClaimSeparator().get() : " ";
            return Arrays.asList(claimValue.toString().split(sep));
        }
        return Collections.emptyList();
    }

    private static String[] splitClaimPath(String claimPath) {
        String[] stringArray;
        if (claimPath.indexOf(47) > 0) {
            stringArray = CLAIM_PATH_PATTERN.split(claimPath);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = claimPath;
        }
        return stringArray;
    }

    private static Object findClaimValue(String claimPath, JsonObject json, String[] pathArray, int step, boolean mustExist) {
        Object claimValue = json.getValue(pathArray[step].replace("\"", ""));
        if (claimValue == null) {
            if (mustExist) {
                throw new OIDCException("No claim exists at the path " + claimPath + " at the path segment " + pathArray[step]);
            }
        } else if (step + 1 < pathArray.length) {
            if (claimValue instanceof JsonObject) {
                int nextStep = step + 1;
                return OidcUtils.findClaimValue(claimPath, (JsonObject)claimValue, pathArray, nextStep, mustExist);
            }
            throw new OIDCException("Claim value at the path " + claimPath + " is not a json object");
        }
        return claimValue;
    }

    private static List<String> convertJsonArrayToList(JsonArray claimValue) {
        ArrayList<String> list = new ArrayList<String>(claimValue.size());
        for (int i = 0; i < claimValue.size(); ++i) {
            list.add(claimValue.getString(i));
        }
        return list;
    }

    static QuarkusSecurityIdentity validateAndCreateIdentity(RoutingContext vertxContext, TokenCredential credential, TenantConfigContext resolvedContext, JsonObject tokenJson, JsonObject rolesJson, JsonObject userInfo) {
        OidcJwtCallerPrincipal jwtPrincipal;
        OidcTenantConfig config = resolvedContext.oidcConfig;
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
        builder.addCredential((Credential)credential);
        try {
            JwtClaims jwtClaims = JwtClaims.parse((String)tokenJson.encode());
            jwtClaims.setClaim(Claims.raw_token.name(), (Object)credential.getToken());
            jwtPrincipal = new OidcJwtCallerPrincipal(jwtClaims, credential, config.token.principalClaim.isPresent() ? config.token.principalClaim.get() : null);
        }
        catch (InvalidJwtException e) {
            throw new AuthenticationFailedException((Throwable)e);
        }
        builder.setPrincipal((Principal)((Object)jwtPrincipal));
        OidcUtils.setSecurityIdentityRoles(builder, config, rolesJson);
        OidcUtils.setSecurityIdentityUserInfo(builder, userInfo);
        OidcUtils.setSecurityIdentityConfigMetadata(builder, resolvedContext);
        OidcUtils.setBlockinApiAttribute(builder, vertxContext);
        OidcUtils.setTenantIdAttribute(builder, config);
        return builder.build();
    }

    public static void setSecurityIdentityRoles(QuarkusSecurityIdentity.Builder builder, OidcTenantConfig config, JsonObject rolesJson) {
        try {
            String clientId = config.getClientId().isPresent() ? (String)config.getClientId().get() : null;
            for (String role : OidcUtils.findRoles(clientId, config.getRoles(), rolesJson)) {
                builder.addRole(role);
            }
        }
        catch (Exception e) {
            throw new ForbiddenException((Throwable)e);
        }
    }

    public static void setBlockinApiAttribute(QuarkusSecurityIdentity.Builder builder, RoutingContext vertxContext) {
        if (vertxContext != null) {
            builder.addAttribute(AuthenticationRequestContext.class.getName(), vertxContext.get(AuthenticationRequestContext.class.getName()));
        }
    }

    public static void setTenantIdAttribute(QuarkusSecurityIdentity.Builder builder, OidcTenantConfig config) {
        builder.addAttribute(TENANT_ID_ATTRIBUTE, (Object)config.tenantId.orElse("Default"));
    }

    public static void setSecurityIdentityUserInfo(QuarkusSecurityIdentity.Builder builder, JsonObject userInfo) {
        if (userInfo != null) {
            builder.addAttribute(USER_INFO_ATTRIBUTE, (Object)new UserInfo(userInfo.encode()));
        }
    }

    public static void setSecurityIdentityConfigMetadata(QuarkusSecurityIdentity.Builder builder, TenantConfigContext resolvedContext) {
        if (resolvedContext.provider.client != null) {
            builder.addAttribute(CONFIG_METADATA_ATTRIBUTE, (Object)resolvedContext.provider.client.getMetadata());
        }
    }

    public static void validatePrimaryJwtTokenType(OidcTenantConfig.Token tokenConfig, JsonObject tokenJson) {
        if (tokenJson.containsKey("typ")) {
            String type = tokenJson.getString("typ");
            if (tokenConfig.getTokenType().isPresent() && !tokenConfig.getTokenType().get().equals(type)) {
                throw new OIDCException("Invalid token type");
            }
            if ("Refresh".equals(type)) {
                throw new OIDCException("Refresh token can only be used with the refresh token grant");
            }
        }
    }
}

