/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.security.identity.SecurityIdentity;
import java.util.Map;

public class SecurityEvent {
    private final Type eventType;
    private final SecurityIdentity securityIdentity;
    private final Map<String, Object> eventProperties;

    public SecurityEvent(Type eventType, SecurityIdentity securityIdentity) {
        this.eventType = eventType;
        this.securityIdentity = securityIdentity;
        this.eventProperties = Map.of();
    }

    public SecurityEvent(Type eventType, Map<String, Object> eventProperties) {
        this.eventType = eventType;
        this.securityIdentity = null;
        this.eventProperties = eventProperties;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public Map<String, Object> getEventProperties() {
        return this.eventProperties;
    }

    public static enum Type {
        OIDC_LOGIN,
        OIDC_SESSION_REFRESHED,
        OIDC_SESSION_EXPIRED_AND_REFRESHED,
        OIDC_LOGOUT_RP_INITIATED,
        OIDC_BACKCHANNEL_LOGOUT_INITIATED,
        OIDC_BACKCHANNEL_LOGOUT_COMPLETED,
        OIDC_FRONTCHANNEL_LOGOUT_COMPLETED;

    }
}

