/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.logging.Log;
import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.AbstractJsonObjectResponse;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.CodeAuthenticationStateBean;
import io.quarkus.oidc.runtime.LogoutException;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.PkceStateBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.build.JwtClaimsBuilder;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.CookieImpl;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.core.MultiMap;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.JoseException;

public class CodeAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    static final String AMP = "&";
    static final String EQ = "=";
    static final String UNDERSCORE = "_";
    static final String COOKIE_DELIM = "|";
    static final Pattern COOKIE_PATTERN = Pattern.compile("\\|");
    static final String SESSION_MAX_AGE_PARAM = "session-max-age";
    static final String STATE_COOKIE_RESTORE_PATH = "restore-path";
    static final Uni<Void> VOID_UNI = Uni.createFrom().voidItem();
    static final Integer MAX_COOKIE_VALUE_LENGTH = 4096;
    static final String NO_OIDC_COOKIES_AVAILABLE = "no_oidc_cookies";
    private static final String INTERNAL_IDTOKEN_HEADER = "internal";
    private static final Logger LOG = Logger.getLogger(CodeAuthenticationMechanism.class);
    private final BlockingTaskRunner<String> createTokenStateRequestContext = new BlockingTaskRunner();
    private final BlockingTaskRunner<AuthorizationCodeTokens> getTokenStateRequestContext = new BlockingTaskRunner();
    private final SecureRandom secureRandom = new SecureRandom();

    public Uni<SecurityIdentity> authenticate(final RoutingContext context, final IdentityProviderManager identityProviderManager, final OidcTenantConfig oidcTenantConfig) {
        Map cookies = context.request().cookieMap();
        final Cookie sessionCookie = (Cookie)cookies.get(CodeAuthenticationMechanism.getSessionCookieName(oidcTenantConfig));
        if (sessionCookie != null) {
            LOG.debug((Object)"Session cookie is present, starting the reauthentication");
            context.put("q_session", (Object)sessionCookie.getName());
            Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
            return resolvedContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                    return CodeAuthenticationMechanism.this.reAuthenticate(sessionCookie, context, identityProviderManager, tenantContext);
                }
            });
        }
        if (this.isStateCookieAvailable(cookies)) {
            if (OidcTenantConfig.Authentication.ResponseMode.FORM_POST == oidcTenantConfig.authentication.responseMode.orElse(OidcTenantConfig.Authentication.ResponseMode.QUERY)) {
                if (OidcUtils.isFormUrlEncodedRequest(context)) {
                    return OidcUtils.getFormUrlEncodedData(context).onItem().transformToUni((Function)new Function<io.vertx.core.MultiMap, Uni<? extends SecurityIdentity>>(){

                        @Override
                        public Uni<? extends SecurityIdentity> apply(io.vertx.core.MultiMap requestParams) {
                            return CodeAuthenticationMechanism.this.processRedirectFromOidc(context, oidcTenantConfig, identityProviderManager, requestParams);
                        }
                    });
                }
                LOG.debug((Object)("HTTP POST and " + HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString() + " content type must be used with the form_post response mode"));
                return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
            }
            return this.processRedirectFromOidc(context, oidcTenantConfig, identityProviderManager, context.queryParams());
        }
        context.put(NO_OIDC_COOKIES_AVAILABLE, (Object)Boolean.TRUE);
        return Uni.createFrom().optional(Optional.empty());
    }

    private boolean isStateCookieAvailable(Map<String, Cookie> cookies) {
        for (String name : cookies.keySet()) {
            if (!name.startsWith("q_auth")) continue;
            return true;
        }
        return false;
    }

    private Uni<SecurityIdentity> processRedirectFromOidc(final RoutingContext context, final OidcTenantConfig oidcTenantConfig, final IdentityProviderManager identityProviderManager, final io.vertx.core.MultiMap requestParams) {
        List stateQueryParam = requestParams.getAll("state");
        if (stateQueryParam.size() != 1) {
            LOG.debug((Object)"State parameter can not be empty or multi-valued if the state cookie is present");
            return this.stateCookieIsMissing(oidcTenantConfig, context);
        }
        Cookie stateCookie = context.request().getCookie(CodeAuthenticationMechanism.getStateCookieName(oidcTenantConfig) + UNDERSCORE + (String)stateQueryParam.get(0));
        if (stateCookie == null) {
            LOG.debug((Object)"Matching state cookie is not found");
            return this.stateCookieIsMissing(oidcTenantConfig, context);
        }
        final String[] parsedStateCookieValue = COOKIE_PATTERN.split(stateCookie.getValue());
        OidcUtils.removeCookie(context, oidcTenantConfig, stateCookie.getName());
        if (!parsedStateCookieValue[0].equals(stateQueryParam.get(0))) {
            LOG.debug((Object)"State cookie value does not match the state query parameter value, completing the code flow with HTTP status 401");
            return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
        }
        LOG.debug((Object)"State cookie is present, processing an expected redirect from the OIDC provider");
        if (requestParams.contains("code")) {
            LOG.debug((Object)"Authorization code is present, completing the code flow");
            Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
            return resolvedContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                    return CodeAuthenticationMechanism.this.performCodeFlow(identityProviderManager, context, tenantContext, requestParams, parsedStateCookieValue);
                }
            });
        }
        if (requestParams.contains("error")) {
            OidcUtils.removeCookie(context, oidcTenantConfig, stateCookie.getName());
            String error = requestParams.get("error");
            String errorDescription = requestParams.get("error_description");
            LOG.debugf("Authentication has failed, error: %s, description: %s", (Object)error, (Object)errorDescription);
            if (oidcTenantConfig.authentication.errorPath.isPresent()) {
                Uni<TenantConfigContext> resolvedContext = this.resolver.resolveContext(context);
                return resolvedContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<SecurityIdentity> apply(TenantConfigContext tenantContext) {
                        String restorePath;
                        int userQueryIndex;
                        URI absoluteUri = URI.create(context.request().absoluteURI());
                        String userQuery = null;
                        CodeAuthenticationStateBean stateBean = CodeAuthenticationMechanism.this.getCodeAuthenticationBean(parsedStateCookieValue, tenantContext);
                        if (stateBean != null && stateBean.getRestorePath() != null && (userQueryIndex = (restorePath = stateBean.getRestorePath()).indexOf("?")) >= 0 && userQueryIndex + 1 < restorePath.length()) {
                            userQuery = restorePath.substring(userQueryIndex + 1);
                        }
                        StringBuilder errorUri = new StringBuilder(CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(oidcTenantConfig), absoluteUri.getAuthority(), oidcTenantConfig.authentication.errorPath.get()));
                        errorUri.append('?').append(CodeAuthenticationMechanism.this.getRequestParametersAsQuery(absoluteUri, requestParams, oidcTenantConfig));
                        if (userQuery != null) {
                            errorUri.append('&').append(userQuery);
                        }
                        String finalErrorUri = errorUri.toString();
                        LOG.debugf("Error URI: %s", (Object)finalErrorUri);
                        return Uni.createFrom().failure((Throwable)new AuthenticationRedirectException(finalErrorUri));
                    }
                });
            }
            LOG.error((Object)"Authentication has failed but no error handler is found, completing the code flow with HTTP status 401");
            return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
        }
        LOG.error((Object)"State cookie is present but neither 'code' nor 'error' query parameter is returned");
        return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
    }

    private Uni<SecurityIdentity> stateCookieIsMissing(OidcTenantConfig oidcTenantConfig, RoutingContext context) {
        if (!oidcTenantConfig.authentication.allowMultipleCodeFlows || context.request().path().equals(this.getRedirectPath(oidcTenantConfig, context))) {
            return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
        }
        context.put(NO_OIDC_COOKIES_AVAILABLE, (Object)Boolean.TRUE);
        return Uni.createFrom().optional(Optional.empty());
    }

    private String getRequestParametersAsQuery(URI requestUri, io.vertx.core.MultiMap requestParams, OidcTenantConfig oidcConfig) {
        if (OidcTenantConfig.Authentication.ResponseMode.FORM_POST == oidcConfig.authentication.responseMode.orElse(OidcTenantConfig.Authentication.ResponseMode.QUERY)) {
            return OidcCommonUtils.encodeForm((MultiMap)new MultiMap(requestParams)).toString();
        }
        return requestUri.getRawQuery();
    }

    private Uni<SecurityIdentity> reAuthenticate(final Cookie sessionCookie, final RoutingContext context, final IdentityProviderManager identityProviderManager, final TenantConfigContext configContext) {
        context.put(TenantConfigContext.class.getName(), (Object)configContext);
        return this.resolver.getTokenStateManager().getTokens(context, configContext.oidcConfig, sessionCookie.getValue(), this.getTokenStateRequestContext).chain((Function)new Function<AuthorizationCodeTokens, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<? extends SecurityIdentity> apply(final AuthorizationCodeTokens session) {
                context.put("access_token", (Object)session.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), (Object)session);
                final String currentIdToken = CodeAuthenticationMechanism.decryptIdTokenIfEncryptedByProvider(configContext, session.getIdToken());
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(currentIdToken, CodeAuthenticationMechanism.this.isInternalIdToken(currentIdToken, configContext))).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        if (CodeAuthenticationMechanism.this.isLogout(context, configContext)) {
                            LOG.debug((Object)"Performing an RP initiated logout");
                            CodeAuthenticationMechanism.this.fireEvent(SecurityEvent.Type.OIDC_LOGOUT_RP_INITIATED, identity);
                            return CodeAuthenticationMechanism.this.buildLogoutRedirectUriUni(context, configContext, session.getIdToken());
                        }
                        if (CodeAuthenticationMechanism.this.isBackChannelLogoutPendingAndValid(configContext, identity) || CodeAuthenticationMechanism.this.isFrontChannelLogoutValid(context, configContext, identity)) {
                            return OidcUtils.removeSessionCookie(context, configContext.oidcConfig, sessionCookie.getName(), CodeAuthenticationMechanism.this.resolver.getTokenStateManager()).map((Function)new Function<Void, Void>(){

                                @Override
                                public Void apply(Void t) {
                                    throw new LogoutException();
                                }
                            });
                        }
                        return VOID_UNI;
                    }
                }).onFailure().recoverWithUni((Function)new Function<Throwable, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<? extends SecurityIdentity> apply(Throwable t) {
                        if (t instanceof AuthenticationRedirectException) {
                            LOG.debug((Object)"Redirecting after the reauthentication");
                            return Uni.createFrom().failure((Throwable)((AuthenticationRedirectException)t));
                        }
                        if (t instanceof LogoutException) {
                            LOG.debugf("User has been logged out, authentication challenge is required", new Object[0]);
                            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                        }
                        if (!(t instanceof TokenAutoRefreshException)) {
                            boolean expired;
                            boolean bl = expired = t.getCause() instanceof InvalidJwtException && ((InvalidJwtException)t.getCause()).hasErrorCode(1);
                            if (!expired) {
                                LOG.errorf("ID token verification failure: %s", (Object)t.getCause());
                                return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException(t.getCause()));
                            }
                            if (session.getRefreshToken() == null) {
                                LOG.debug((Object)"Token has expired, token refresh is not possible because the refresh token is null");
                                return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t.getCause()));
                            }
                            if (!configContext.oidcConfig.token.refreshExpired) {
                                LOG.debug((Object)"Token has expired, token refresh is not allowed");
                                return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t.getCause()));
                            }
                            LOG.debug((Object)"Token has expired, trying to refresh it");
                            return CodeAuthenticationMechanism.this.refreshSecurityIdentity(configContext, currentIdToken, session.getRefreshToken(), context, identityProviderManager, false, null);
                        }
                        if (session.getRefreshToken() != null) {
                            LOG.debug((Object)"Token auto-refresh is starting");
                            return CodeAuthenticationMechanism.this.refreshSecurityIdentity(configContext, currentIdToken, session.getRefreshToken(), context, identityProviderManager, true, ((TokenAutoRefreshException)t).getSecurityIdentity());
                        }
                        LOG.debug((Object)"Token auto-refresh is required but is not possible because the refresh token is null");
                        SecurityIdentity currentIdentity = ((TokenAutoRefreshException)t).getSecurityIdentity();
                        if (currentIdentity != null) {
                            return Uni.createFrom().item((Object)currentIdentity);
                        }
                        return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t.getCause()));
                    }
                });
            }
        });
    }

    private static String decryptIdTokenIfEncryptedByProvider(TenantConfigContext resolvedContext, String token) {
        if ((resolvedContext.provider.tokenDecryptionKey != null || resolvedContext.provider.client.getClientJwtKey() != null) && OidcUtils.isEncryptedToken(token)) {
            try {
                return OidcUtils.decryptString(token, resolvedContext.provider.tokenDecryptionKey != null ? resolvedContext.provider.tokenDecryptionKey : resolvedContext.provider.client.getClientJwtKey(), KeyEncryptionAlgorithm.RSA_OAEP);
            }
            catch (JoseException ex) {
                Log.debugf((String)"Failed to decrypt a token: %s, a token introspection will be attempted instead", (Object)ex.getMessage());
            }
        }
        return token;
    }

    private boolean isBackChannelLogoutPendingAndValid(TenantConfigContext configContext, SecurityIdentity identity) {
        TokenVerificationResult backChannelLogoutTokenResult = this.resolver.getBackChannelLogoutTokens().remove(configContext.oidcConfig.getTenantId().get());
        if (backChannelLogoutTokenResult != null) {
            JsonObject idTokenJson = OidcUtils.decodeJwtContent(((JsonWebToken)identity.getPrincipal()).getRawToken());
            String idTokenIss = idTokenJson.getString(Claims.iss.name());
            String logoutTokenIss = backChannelLogoutTokenResult.localVerificationResult.getString(Claims.iss.name());
            if (logoutTokenIss != null && !logoutTokenIss.equals(idTokenIss)) {
                LOG.debugf("Logout token issuer does not match the ID token issuer", new Object[0]);
                return false;
            }
            String idTokenSub = idTokenJson.getString(Claims.sub.name());
            String logoutTokenSub = backChannelLogoutTokenResult.localVerificationResult.getString(Claims.sub.name());
            if (logoutTokenSub != null && idTokenSub != null && !logoutTokenSub.equals(idTokenSub)) {
                LOG.debugf("Logout token subject does not match the ID token subject", new Object[0]);
                return false;
            }
            String idTokenSid = idTokenJson.getString("sid");
            String logoutTokenSid = backChannelLogoutTokenResult.localVerificationResult.getString("sid");
            if (logoutTokenSid != null && idTokenSid != null && !logoutTokenSid.equals(idTokenSid)) {
                LOG.debugf("Logout token session id does not match the ID token session id", new Object[0]);
                return false;
            }
            LOG.debugf("Frontchannel logout request for the tenant %s has been completed", (Object)configContext.oidcConfig.tenantId.get());
            this.fireEvent(SecurityEvent.Type.OIDC_BACKCHANNEL_LOGOUT_COMPLETED, identity);
            return true;
        }
        return false;
    }

    private boolean isFrontChannelLogoutValid(RoutingContext context, TenantConfigContext configContext, SecurityIdentity identity) {
        if (this.isEqualToRequestPath(configContext.oidcConfig.logout.frontchannel.path, context, configContext)) {
            JsonObject idTokenJson = OidcUtils.decodeJwtContent(((JsonWebToken)identity.getPrincipal()).getRawToken());
            String idTokenIss = idTokenJson.getString(Claims.iss.name());
            List frontChannelIss = context.queryParam(Claims.iss.name());
            if (frontChannelIss != null && frontChannelIss.size() == 1 && !((String)frontChannelIss.get(0)).equals(idTokenIss)) {
                LOG.debugf("Frontchannel issuer parameter does not match the ID token issuer", new Object[0]);
                return false;
            }
            String idTokenSid = idTokenJson.getString("sid");
            List frontChannelSid = context.queryParam("sid");
            if (frontChannelSid != null && frontChannelSid.size() == 1 && !((String)frontChannelSid.get(0)).equals(idTokenSid)) {
                LOG.debugf("Frontchannel session id parameter does not match the ID token session id", new Object[0]);
                return false;
            }
            LOG.debugf("Frontchannel logout request for the tenant %s has been completed", (Object)configContext.oidcConfig.tenantId.get());
            this.fireEvent(SecurityEvent.Type.OIDC_FRONTCHANNEL_LOGOUT_COMPLETED, identity);
            return true;
        }
        return false;
    }

    private boolean isInternalIdToken(String idToken, TenantConfigContext configContext) {
        JsonObject headers;
        if (!configContext.oidcConfig.authentication.idTokenRequired.orElse(true).booleanValue() && (headers = OidcUtils.decodeJwtHeaders(idToken)) != null) {
            return headers.getBoolean(INTERNAL_IDTOKEN_HEADER, Boolean.valueOf(false));
        }
        return false;
    }

    private boolean isIdTokenRequired(TenantConfigContext configContext) {
        return configContext.oidcConfig.authentication.isIdTokenRequired().orElse(true);
    }

    private boolean isJavaScript(RoutingContext context) {
        String value = context.request().getHeader("X-Requested-With");
        return "JavaScript".equals(value) || "XMLHttpRequest".equals(value);
    }

    private boolean shouldAutoRedirect(TenantConfigContext configContext, RoutingContext context) {
        return this.isJavaScript(context) ? configContext.oidcConfig.authentication.javaScriptAutoRedirect : true;
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext context) {
        Uni<TenantConfigContext> tenantContext = this.resolver.resolveContext(context);
        return tenantContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(TenantConfigContext tenantContext) {
                return CodeAuthenticationMechanism.this.getChallengeInternal(context, tenantContext);
            }
        });
    }

    public Uni<ChallengeData> getChallengeInternal(final RoutingContext context, final TenantConfigContext configContext) {
        LOG.debug((Object)"Starting an authentication challenge");
        return this.removeSessionCookie(context, configContext.oidcConfig).chain((Function)new Function<Void, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(Void t) {
                if (context.get(CodeAuthenticationMechanism.NO_OIDC_COOKIES_AVAILABLE) != null && CodeAuthenticationMechanism.this.isRedirectFromProvider(context, configContext)) {
                    LOG.debug((Object)"The state cookie is missing after the redirect from OpenId Connect Provider, authentication has failed");
                    return Uni.createFrom().item((Object)new ChallengeData(401, (CharSequence)"WWW-Authenticate", "OIDC"));
                }
                if (!CodeAuthenticationMechanism.this.shouldAutoRedirect(configContext, context)) {
                    return Uni.createFrom().item((Object)new ChallengeData(499, (CharSequence)"WWW-Authenticate", "OIDC"));
                }
                StringBuilder codeFlowParams = new StringBuilder(168);
                codeFlowParams.append("response_type").append(CodeAuthenticationMechanism.EQ).append("code");
                if (OidcTenantConfig.Authentication.ResponseMode.FORM_POST == configContext.oidcConfig.authentication.responseMode.orElse(OidcTenantConfig.Authentication.ResponseMode.QUERY)) {
                    codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("response_mode").append(CodeAuthenticationMechanism.EQ).append(configContext.oidcConfig.authentication.responseMode.get().toString().toLowerCase());
                }
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("client_id").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)((String)configContext.oidcConfig.clientId.get())));
                List oidcConfigScopes = configContext.oidcConfig.getAuthentication().scopes.isPresent() ? configContext.oidcConfig.getAuthentication().scopes.get() : Collections.emptyList();
                ArrayList<String> scopes = new ArrayList<String>(oidcConfigScopes.size() + 1);
                if (configContext.oidcConfig.getAuthentication().addOpenidScope.orElse(true).booleanValue()) {
                    scopes.add("openid");
                }
                scopes.addAll(oidcConfigScopes);
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("scope").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)String.join((CharSequence)" ", scopes)));
                io.vertx.core.MultiMap requestQueryParams = null;
                if (!configContext.oidcConfig.getAuthentication().forwardParams.isEmpty()) {
                    requestQueryParams = context.queryParams();
                    for (String forwardedParam : configContext.oidcConfig.getAuthentication().forwardParams.get()) {
                        if (!requestQueryParams.contains(forwardedParam)) continue;
                        for (String requestQueryParamValue : requestQueryParams.getAll(forwardedParam)) {
                            codeFlowParams.append(CodeAuthenticationMechanism.AMP).append(forwardedParam).append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)requestQueryParamValue));
                        }
                        requestQueryParams.remove(forwardedParam);
                    }
                }
                String redirectPath = CodeAuthenticationMechanism.this.getRedirectPath(configContext.oidcConfig, context);
                String redirectUriParam = CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(configContext.oidcConfig), redirectPath);
                LOG.debugf("Authentication request redirect_uri parameter: %s", (Object)redirectUriParam);
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("redirect_uri").append(CodeAuthenticationMechanism.EQ).append(OidcCommonUtils.urlEncode((String)redirectUriParam));
                PkceStateBean pkceStateBean = CodeAuthenticationMechanism.this.createPkceStateBean(configContext);
                codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("state").append(CodeAuthenticationMechanism.EQ).append(CodeAuthenticationMechanism.this.generateCodeFlowState(context, configContext, redirectPath, requestQueryParams, pkceStateBean != null ? pkceStateBean.getCodeVerifier() : null));
                if (pkceStateBean != null) {
                    codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("code_challenge").append(CodeAuthenticationMechanism.EQ).append(pkceStateBean.getCodeChallenge());
                    codeFlowParams.append(CodeAuthenticationMechanism.AMP).append("code_challenge_method").append(CodeAuthenticationMechanism.EQ).append("S256");
                }
                CodeAuthenticationMechanism.addExtraParamsToUri(codeFlowParams, configContext.oidcConfig.authentication.getExtraParams());
                String authorizationURL = configContext.provider.getMetadata().getAuthorizationUri() + "?" + codeFlowParams.toString();
                LOG.debugf("Code flow redirect to: %s", (Object)authorizationURL);
                return Uni.createFrom().item((Object)new ChallengeData(HttpResponseStatus.FOUND.code(), HttpHeaders.LOCATION, authorizationURL));
            }
        });
    }

    private boolean isRedirectFromProvider(RoutingContext context, TenantConfigContext configContext) {
        String referer = context.request().getHeader(HttpHeaders.REFERER);
        return referer != null && referer.startsWith(configContext.provider.getMetadata().getAuthorizationUri());
    }

    private PkceStateBean createPkceStateBean(TenantConfigContext configContext) {
        if (configContext.oidcConfig.authentication.pkceRequired.orElse(false).booleanValue()) {
            PkceStateBean bean = new PkceStateBean();
            Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
            byte[] codeVerifierBytes = new byte[32];
            this.secureRandom.nextBytes(codeVerifierBytes);
            String codeVerifier = encoder.encodeToString(codeVerifierBytes);
            bean.setCodeVerifier(codeVerifier);
            try {
                byte[] codeChallengeBytes = OidcUtils.getSha256Digest(codeVerifier.getBytes(StandardCharsets.ISO_8859_1));
                String codeChallenge = encoder.encodeToString(codeChallengeBytes);
                bean.setCodeChallenge(codeChallenge);
            }
            catch (Exception ex) {
                LOG.errorf("Code challenge creation failure: %s", (Object)ex.getMessage());
                throw new AuthenticationCompletionException((Throwable)ex);
            }
            return bean;
        }
        return null;
    }

    private Uni<SecurityIdentity> performCodeFlow(final IdentityProviderManager identityProviderManager, final RoutingContext context, final TenantConfigContext configContext, final io.vertx.core.MultiMap requestParams, String[] parsedStateCookieValue) {
        String userPath = null;
        String userQuery = null;
        CodeAuthenticationStateBean stateBean = this.getCodeAuthenticationBean(parsedStateCookieValue, configContext);
        if (stateBean != null && stateBean.getRestorePath() != null) {
            String restorePath = stateBean.getRestorePath();
            int userQueryIndex = restorePath.indexOf("?");
            if (userQueryIndex >= 0) {
                String string = userPath = this.isRestorePath(configContext.oidcConfig.authentication) ? restorePath.substring(0, userQueryIndex) : null;
                if (userQueryIndex + 1 < restorePath.length()) {
                    userQuery = restorePath.substring(userQueryIndex + 1);
                }
            } else {
                userPath = restorePath;
            }
        }
        final String finalUserPath = userPath;
        final String finalUserQuery = userQuery;
        String code = requestParams.get("code");
        LOG.debug((Object)"Exchanging the authorization code for the tokens");
        Uni<AuthorizationCodeTokens> codeFlowTokensUni = this.getCodeFlowTokensUni(context, configContext, code, stateBean != null ? stateBean.getCodeVerifier() : null);
        return codeFlowTokensUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<AuthorizationCodeTokens, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final AuthorizationCodeTokens tokens, Throwable tOuter) {
                boolean internalIdToken;
                if (tOuter != null) {
                    LOG.errorf("Exception during the code to token exchange: %s", (Object)tOuter.getMessage());
                    return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException(tOuter));
                }
                boolean bl = internalIdToken = !CodeAuthenticationMechanism.this.isIdTokenRequired(configContext);
                if (tokens.getIdToken() == null) {
                    if (!internalIdToken) {
                        LOG.errorf("ID token is not available in the authorization code grant response", new Object[0]);
                        return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException());
                    }
                    tokens.setIdToken(CodeAuthenticationMechanism.this.generateInternalIdToken(configContext.oidcConfig, null, null));
                }
                context.put("new_authentication", (Object)Boolean.TRUE);
                context.put("access_token", (Object)tokens.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), (Object)tokens);
                final String idToken = CodeAuthenticationMechanism.decryptIdTokenIfEncryptedByProvider(configContext, tokens.getIdToken());
                LOG.debug((Object)"Authorization code has been exchanged, verifying ID token");
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(idToken, internalIdToken)).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        if (internalIdToken && configContext.oidcConfig.allowUserInfoCache && configContext.oidcConfig.cacheUserInfoInIdtoken) {
                            tokens.setIdToken(CodeAuthenticationMechanism.this.generateInternalIdToken(configContext.oidcConfig, (UserInfo)identity.getAttribute("userinfo"), null));
                        }
                        return CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, tokens, idToken, identity);
                    }
                }).map((Function)new Function<SecurityIdentity, SecurityIdentity>(){

                    @Override
                    public SecurityIdentity apply(SecurityIdentity identity) {
                        boolean removeRedirectParams = configContext.oidcConfig.authentication.isRemoveRedirectParameters();
                        if (removeRedirectParams || finalUserPath != null || finalUserQuery != null) {
                            URI absoluteUri = URI.create(context.request().absoluteURI());
                            StringBuilder finalUriWithoutQuery = new StringBuilder(CodeAuthenticationMechanism.this.buildUri(context, CodeAuthenticationMechanism.this.isForceHttps(configContext.oidcConfig), absoluteUri.getAuthority(), finalUserPath != null ? finalUserPath : absoluteUri.getRawPath()));
                            if (!removeRedirectParams) {
                                finalUriWithoutQuery.append('?').append(CodeAuthenticationMechanism.this.getRequestParametersAsQuery(absoluteUri, requestParams, configContext.oidcConfig));
                            }
                            if (finalUserQuery != null) {
                                finalUriWithoutQuery.append(!removeRedirectParams ? "" : "?");
                                finalUriWithoutQuery.append(finalUserQuery);
                            }
                            String finalRedirectUri = finalUriWithoutQuery.toString();
                            LOG.debugf("Removing code flow redirect parameters, final redirect URI: %s", (Object)finalRedirectUri);
                            throw new AuthenticationRedirectException(finalRedirectUri);
                        }
                        return identity;
                    }
                }).onFailure().transform((Function)new Function<Throwable, Throwable>(){

                    @Override
                    public Throwable apply(Throwable tInner) {
                        if (tInner instanceof AuthenticationRedirectException) {
                            LOG.debugf("Starting the final redirect", new Object[0]);
                            return tInner;
                        }
                        LOG.errorf("ID token verification has failed: %s", (Object)tInner.getMessage());
                        return new AuthenticationCompletionException(tInner);
                    }
                });
            }
        });
    }

    private CodeAuthenticationStateBean getCodeAuthenticationBean(String[] parsedStateCookieValue, TenantConfigContext configContext) {
        if (parsedStateCookieValue.length == 2) {
            CodeAuthenticationStateBean bean = new CodeAuthenticationStateBean();
            if (!configContext.oidcConfig.authentication.pkceRequired.orElse(false).booleanValue()) {
                bean.setRestorePath(parsedStateCookieValue[1]);
                return bean;
            }
            JsonObject json = null;
            try {
                json = OidcUtils.decryptJson(parsedStateCookieValue[1], configContext.getPkceSecretKey());
            }
            catch (Exception ex) {
                LOG.errorf("State cookie value can not be decrypted for the %s tenant", (Object)configContext.oidcConfig.tenantId.get());
                throw new AuthenticationCompletionException((Throwable)ex);
            }
            bean.setRestorePath(json.getString(STATE_COOKIE_RESTORE_PATH));
            bean.setCodeVerifier(json.getString("code_verifier"));
            return bean;
        }
        return null;
    }

    private String generateInternalIdToken(OidcTenantConfig oidcConfig, UserInfo userInfo, String currentIdToken) {
        JwtClaimsBuilder builder = Jwt.claims();
        if (currentIdToken != null) {
            AbstractJsonObjectResponse currentIdTokenJson = new AbstractJsonObjectResponse(OidcUtils.decodeJwtContentAsString(currentIdToken)){};
            for (String claim : currentIdTokenJson.getPropertyNames()) {
                if (claim.equals(Claims.iat.name()) || claim.equals(Claims.exp.name())) continue;
                builder.claim(claim, currentIdTokenJson.get(claim));
            }
        }
        if (userInfo != null) {
            builder.claim("userinfo", (Object)userInfo.getJsonObject());
        }
        if (oidcConfig.authentication.internalIdTokenLifespan.isPresent()) {
            builder.expiresIn(oidcConfig.authentication.internalIdTokenLifespan.get().getSeconds());
        }
        return builder.jws().header(INTERNAL_IDTOKEN_HEADER, (Object)true).sign(KeyUtils.createSecretKeyFromSecret((String)OidcCommonUtils.clientSecret((OidcCommonConfig.Credentials)oidcConfig.credentials)));
    }

    private Uni<Void> processSuccessfulAuthentication(final RoutingContext context, final TenantConfigContext configContext, final AuthorizationCodeTokens tokens, final String idToken, final SecurityIdentity securityIdentity) {
        LOG.debug((Object)"ID token has been verified, removing the existing session cookie if any and creating a new one");
        return this.removeSessionCookie(context, configContext.oidcConfig).chain((Function)new Function<Void, Uni<? extends Void>>(){

            @Override
            public Uni<? extends Void> apply(Void t) {
                JsonObject idTokenJson = OidcUtils.decodeJwtContent(idToken);
                if (!idTokenJson.containsKey("exp") || !idTokenJson.containsKey("iat")) {
                    LOG.error((Object)"ID Token is required to contain 'exp' and 'iat' claims");
                    throw new AuthenticationCompletionException();
                }
                long maxAge = idTokenJson.getLong("exp") - idTokenJson.getLong("iat");
                LOG.debugf("ID token is valid for %d seconds", maxAge);
                if (configContext.oidcConfig.token.lifespanGrace.isPresent()) {
                    maxAge += (long)configContext.oidcConfig.token.lifespanGrace.getAsInt();
                }
                if (configContext.oidcConfig.token.refreshExpired) {
                    maxAge += configContext.oidcConfig.authentication.sessionAgeExtension.getSeconds();
                }
                final long sessionMaxAge = maxAge;
                context.put(CodeAuthenticationMechanism.SESSION_MAX_AGE_PARAM, (Object)maxAge);
                context.put(TenantConfigContext.class.getName(), (Object)configContext);
                CodeAuthenticationMechanism.this.resolver.getBackChannelLogoutTokens().remove(configContext.oidcConfig.tenantId.get());
                return CodeAuthenticationMechanism.this.resolver.getTokenStateManager().createTokenState(context, configContext.oidcConfig, tokens, CodeAuthenticationMechanism.this.createTokenStateRequestContext).map((Function)new Function<String, Void>(){

                    @Override
                    public Void apply(String cookieValue) {
                        String sessionCookie = CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getSessionCookieName(configContext.oidcConfig), cookieValue, sessionMaxAge, true).getValue();
                        if (sessionCookie.length() >= MAX_COOKIE_VALUE_LENGTH) {
                            LOG.warnf("Session cookie length for the tenant %s is equal or greater than %d bytes. Browsers may ignore this cookie which will cause a new challenge for the authenticated users. Recommendations: 1. Set 'quarkus.oidc.token-state-manager.split-tokens=true' to have the ID, access and refresh tokens stored in separate cookies. 2. Set 'quarkus.oidc.token-state-manager.strategy=id-refresh-tokens' if you do not need to use the access token as a source of roles or to request UserInfo or propagate it to the downstream services. 3. Register a custom 'quarkus.oidc.TokenStateManager' CDI bean with the alternative priority set to 1.", (Object)configContext.oidcConfig.tenantId.get(), (Object)MAX_COOKIE_VALUE_LENGTH);
                        }
                        CodeAuthenticationMechanism.this.fireEvent(SecurityEvent.Type.OIDC_LOGIN, securityIdentity);
                        return null;
                    }
                });
            }
        });
    }

    private void fireEvent(SecurityEvent.Type eventType, SecurityIdentity securityIdentity) {
        if (this.resolver.isSecurityEventObserved()) {
            this.resolver.getSecurityEvent().fire((Object)new SecurityEvent(eventType, securityIdentity));
        }
    }

    private String getRedirectPath(OidcTenantConfig oidcConfig, RoutingContext context) {
        OidcTenantConfig.Authentication auth = oidcConfig.getAuthentication();
        return auth.getRedirectPath().isPresent() ? auth.getRedirectPath().get() : context.request().path();
    }

    private String generateCodeFlowState(RoutingContext context, TenantConfigContext configContext, String redirectPath, io.vertx.core.MultiMap requestQueryWithoutForwardedParams, String pkceCodeVerifier) {
        String uuid = UUID.randomUUID().toString();
        Object cookieValue = uuid;
        boolean restorePath = this.isRestorePath(configContext.oidcConfig.getAuthentication());
        if (restorePath || pkceCodeVerifier != null) {
            CodeAuthenticationStateBean extraStateValue = new CodeAuthenticationStateBean();
            if (restorePath) {
                Object requestPath;
                String requestQuery = context.request().query();
                Object object = requestPath = !redirectPath.equals(context.request().path()) || requestQuery != null ? context.request().path() : "";
                if (requestQuery != null) {
                    requestPath = (String)requestPath + "?";
                    if (requestQueryWithoutForwardedParams == null) {
                        requestPath = (String)requestPath + requestQuery;
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (String requestQueryParam : requestQueryWithoutForwardedParams.names()) {
                            for (String requestQueryParamValue : requestQueryWithoutForwardedParams.getAll(requestQueryParam)) {
                                if (sb.length() > 0) {
                                    sb.append(AMP);
                                }
                                sb.append(requestQueryParam).append(EQ).append(OidcCommonUtils.urlEncode((String)requestQueryParamValue));
                            }
                        }
                        requestPath = (String)requestPath + sb.toString();
                    }
                }
                if (!((String)requestPath).isEmpty()) {
                    extraStateValue.setRestorePath((String)requestPath);
                }
            }
            extraStateValue.setCodeVerifier(pkceCodeVerifier);
            if (!extraStateValue.isEmpty()) {
                cookieValue = (String)cookieValue + COOKIE_DELIM + this.encodeExtraStateValue(extraStateValue, configContext);
            }
        } else if (context.request().query() != null) {
            CodeAuthenticationStateBean extraStateValue = new CodeAuthenticationStateBean();
            extraStateValue.setRestorePath("?" + context.request().query());
            cookieValue = (String)cookieValue + COOKIE_DELIM + this.encodeExtraStateValue(extraStateValue, configContext);
        }
        CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getStateCookieName(configContext.oidcConfig) + UNDERSCORE + uuid, (String)cookieValue, 1800L);
        return uuid;
    }

    private boolean isRestorePath(OidcTenantConfig.Authentication auth) {
        return auth.isRestorePathAfterRedirect() || !auth.redirectPath.isPresent();
    }

    private String encodeExtraStateValue(CodeAuthenticationStateBean extraStateValue, TenantConfigContext configContext) {
        if (extraStateValue.getCodeVerifier() != null) {
            JsonObject json = new JsonObject();
            json.put("code_verifier", (Object)extraStateValue.getCodeVerifier());
            if (extraStateValue.getRestorePath() != null) {
                json.put(STATE_COOKIE_RESTORE_PATH, (Object)extraStateValue.getRestorePath());
            }
            try {
                return OidcUtils.encryptJson(json, configContext.getPkceSecretKey());
            }
            catch (Exception ex) {
                LOG.errorf("State containing the code verifier can not be encrypted: %s", (Object)ex.getMessage());
                throw new AuthenticationCompletionException((Throwable)ex);
            }
        }
        return extraStateValue.getRestorePath();
    }

    private String generatePostLogoutState(RoutingContext context, TenantConfigContext configContext) {
        OidcUtils.removeCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getPostLogoutCookieName(configContext.oidcConfig));
        return CodeAuthenticationMechanism.createCookie(context, configContext.oidcConfig, CodeAuthenticationMechanism.getPostLogoutCookieName(configContext.oidcConfig), UUID.randomUUID().toString(), 1800L).getValue();
    }

    static ServerCookie createCookie(RoutingContext context, OidcTenantConfig oidcConfig, String name, String value, long maxAge) {
        return CodeAuthenticationMechanism.createCookie(context, oidcConfig, name, value, maxAge, false);
    }

    static ServerCookie createCookie(RoutingContext context, OidcTenantConfig oidcConfig, String name, String value, long maxAge, boolean sessionCookie) {
        CookieImpl cookie = new CookieImpl(name, value);
        cookie.setHttpOnly(true);
        cookie.setSecure(oidcConfig.authentication.cookieForceSecure || context.request().isSSL());
        cookie.setMaxAge(maxAge);
        LOG.debugf(name + " cookie 'max-age' parameter is set to %d", maxAge);
        OidcTenantConfig.Authentication auth = oidcConfig.getAuthentication();
        OidcUtils.setCookiePath(context, auth, (ServerCookie)cookie);
        if (auth.cookieDomain.isPresent()) {
            cookie.setDomain(auth.getCookieDomain().get());
        }
        if (sessionCookie) {
            cookie.setSameSite(CookieSameSite.valueOf((String)auth.cookieSameSite.name()));
        }
        context.response().addCookie((Cookie)cookie);
        return cookie;
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String path) {
        String authority = URI.create(context.request().absoluteURI()).getAuthority();
        return this.buildUri(context, forceHttps, authority, path);
    }

    private String buildUri(RoutingContext context, boolean forceHttps, String authority, String path) {
        String forwardedPrefixHeader;
        String scheme = forceHttps ? "https" : context.request().scheme();
        String forwardedPrefix = "";
        if (this.resolver.isEnableHttpForwardedPrefix() && (forwardedPrefixHeader = context.request().getHeader("X-Forwarded-Prefix")) != null && !forwardedPrefixHeader.equals("/") && !forwardedPrefixHeader.equals("//") && (forwardedPrefix = forwardedPrefixHeader).endsWith("/")) {
            forwardedPrefix = forwardedPrefix.substring(0, forwardedPrefix.length() - 1);
        }
        return scheme + "://" + authority + forwardedPrefix + path;
    }

    private boolean isLogout(RoutingContext context, TenantConfigContext configContext) {
        return this.isEqualToRequestPath(configContext.oidcConfig.logout.path, context, configContext);
    }

    private boolean isEqualToRequestPath(Optional<String> path, RoutingContext context, TenantConfigContext configContext) {
        if (path.isPresent()) {
            return context.request().path().equals(path.get());
        }
        return false;
    }

    private Uni<SecurityIdentity> refreshSecurityIdentity(final TenantConfigContext configContext, String currentIdToken, String refreshToken, final RoutingContext context, final IdentityProviderManager identityProviderManager, final boolean autoRefresh, final SecurityIdentity fallback) {
        Uni<AuthorizationCodeTokens> refreshedTokensUni = this.refreshTokensUni(configContext, currentIdToken, refreshToken, autoRefresh);
        return refreshedTokensUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<AuthorizationCodeTokens, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final AuthorizationCodeTokens tokens, Throwable t) {
                if (t != null) {
                    LOG.debugf("ID token refresh has failed: %s", (Object)t.getMessage());
                    if (autoRefresh && fallback != null) {
                        LOG.debug((Object)"Using the current SecurityIdentity since the ID token is still valid");
                        return Uni.createFrom().item((Object)fallback);
                    }
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                }
                context.put("access_token", (Object)tokens.getAccessToken());
                context.put(AuthorizationCodeTokens.class.getName(), (Object)tokens);
                context.put("refresh_token_grant_response", (Object)Boolean.TRUE);
                final String idToken = CodeAuthenticationMechanism.decryptIdTokenIfEncryptedByProvider(configContext, tokens.getIdToken());
                LOG.debug((Object)"Verifying the refreshed ID token");
                return CodeAuthenticationMechanism.this.authenticate(identityProviderManager, context, new IdTokenCredential(idToken, CodeAuthenticationMechanism.this.isInternalIdToken(idToken, configContext))).call(new Function<SecurityIdentity, Uni<?>>(){

                    @Override
                    public Uni<Void> apply(SecurityIdentity identity) {
                        return CodeAuthenticationMechanism.this.processSuccessfulAuthentication(context, configContext, tokens, idToken, identity);
                    }
                }).map((Function)new Function<SecurityIdentity, SecurityIdentity>(){

                    @Override
                    public SecurityIdentity apply(SecurityIdentity identity) {
                        CodeAuthenticationMechanism.this.fireEvent(autoRefresh ? SecurityEvent.Type.OIDC_SESSION_REFRESHED : SecurityEvent.Type.OIDC_SESSION_EXPIRED_AND_REFRESHED, identity);
                        return identity;
                    }
                }).onFailure().transform((Function)new Function<Throwable, Throwable>(){

                    @Override
                    public Throwable apply(Throwable tInner) {
                        LOG.debugf("Verifying the refreshed ID token failed %s", (Object)tInner.getMessage());
                        return new AuthenticationFailedException(tInner);
                    }
                });
            }
        });
    }

    private Uni<AuthorizationCodeTokens> refreshTokensUni(final TenantConfigContext configContext, final String currentIdToken, final String refreshToken, final boolean autoRefresh) {
        return configContext.provider.refreshTokens(refreshToken).onItem().transform((Function)new Function<AuthorizationCodeTokens, AuthorizationCodeTokens>(){

            @Override
            public AuthorizationCodeTokens apply(AuthorizationCodeTokens tokens) {
                if (tokens.getRefreshToken() == null) {
                    tokens.setRefreshToken(refreshToken);
                }
                if (tokens.getIdToken() == null) {
                    if (CodeAuthenticationMechanism.this.isIdTokenRequired(configContext)) {
                        if (!autoRefresh) {
                            LOG.debugf("ID token is not returned in the refresh token grant response, re-authentication is required", new Object[0]);
                            throw new AuthenticationFailedException();
                        }
                        tokens.setIdToken(currentIdToken);
                    } else {
                        tokens.setIdToken(CodeAuthenticationMechanism.this.generateInternalIdToken(configContext.oidcConfig, null, currentIdToken));
                    }
                }
                return tokens;
            }
        });
    }

    private Uni<AuthorizationCodeTokens> getCodeFlowTokensUni(RoutingContext context, TenantConfigContext configContext, String code, String codeVerifier) {
        String redirectPath = this.getRedirectPath(configContext.oidcConfig, context);
        String redirectUriParam = this.buildUri(context, this.isForceHttps(configContext.oidcConfig), redirectPath);
        LOG.debugf("Token request redirect_uri parameter: %s", (Object)redirectUriParam);
        return configContext.provider.getCodeFlowTokens(code, redirectUriParam, codeVerifier);
    }

    private String buildLogoutRedirectUri(TenantConfigContext configContext, String idToken, RoutingContext context) {
        String logoutPath = configContext.provider.getMetadata().getEndSessionUri();
        StringBuilder logoutUri = new StringBuilder(logoutPath);
        if (idToken != null || configContext.oidcConfig.logout.postLogoutPath.isPresent()) {
            logoutUri.append("?");
        }
        if (idToken != null) {
            logoutUri.append("id_token_hint").append(EQ).append(idToken);
        }
        if (configContext.oidcConfig.logout.postLogoutPath.isPresent()) {
            logoutUri.append(AMP).append(configContext.oidcConfig.logout.getPostLogoutUriParam()).append(EQ).append(this.buildUri(context, this.isForceHttps(configContext.oidcConfig), configContext.oidcConfig.logout.postLogoutPath.get()));
            logoutUri.append(AMP).append("state").append(EQ).append(this.generatePostLogoutState(context, configContext));
        }
        CodeAuthenticationMechanism.addExtraParamsToUri(logoutUri, configContext.oidcConfig.logout.extraParams);
        return logoutUri.toString();
    }

    private static void addExtraParamsToUri(StringBuilder builder, Map<String, String> extraParams) {
        if (extraParams != null) {
            for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                builder.append(AMP).append(entry.getKey()).append(EQ).append(OidcCommonUtils.urlEncode((String)entry.getValue()));
            }
        }
    }

    private boolean isForceHttps(OidcTenantConfig oidcConfig) {
        return oidcConfig.authentication.forceRedirectHttpsScheme.orElse(false);
    }

    private Uni<Void> buildLogoutRedirectUriUni(final RoutingContext context, final TenantConfigContext configContext, final String idToken) {
        return this.removeSessionCookie(context, configContext.oidcConfig).map((Function)new Function<Void, Void>(){

            @Override
            public Void apply(Void t) {
                String logoutUri = CodeAuthenticationMechanism.this.buildLogoutRedirectUri(configContext, idToken, context);
                LOG.debugf("Logout uri: %s", (Object)logoutUri);
                throw new AuthenticationRedirectException(logoutUri);
            }
        });
    }

    private static String getStateCookieName(OidcTenantConfig oidcConfig) {
        return "q_auth" + CodeAuthenticationMechanism.getCookieSuffix(oidcConfig);
    }

    private static String getPostLogoutCookieName(OidcTenantConfig oidcConfig) {
        return "q_post_logout" + CodeAuthenticationMechanism.getCookieSuffix(oidcConfig);
    }

    private static String getSessionCookieName(OidcTenantConfig oidcConfig) {
        return "q_session" + CodeAuthenticationMechanism.getCookieSuffix(oidcConfig);
    }

    private Uni<Void> removeSessionCookie(RoutingContext context, OidcTenantConfig oidcConfig) {
        String cookieName = CodeAuthenticationMechanism.getSessionCookieName(oidcConfig);
        return OidcUtils.removeSessionCookie(context, oidcConfig, cookieName, this.resolver.getTokenStateManager());
    }

    static String getCookieSuffix(OidcTenantConfig oidcConfig) {
        String tenantId = oidcConfig.tenantId.get();
        boolean cookieSuffixConfigured = oidcConfig.authentication.cookieSuffix.isPresent();
        String tenantIdSuffix = cookieSuffixConfigured || !"Default".equals(tenantId) ? UNDERSCORE + tenantId : "";
        return cookieSuffixConfigured ? tenantIdSuffix + UNDERSCORE + oidcConfig.authentication.cookieSuffix.get() : tenantIdSuffix;
    }
}

