/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenCertificateValidator;
import io.quarkus.oidc.runtime.OidcProvider;
import io.quarkus.oidc.runtime.RefreshableVerificationKeyResolver;
import io.quarkus.oidc.runtime.TenantFeatureFinder;
import io.quarkus.oidc.runtime.TrustStoreUtils;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.vertx.ext.auth.impl.CertificateHelper;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.jboss.logging.Logger;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.UnresolvableKeyException;

public class CertChainPublicKeyResolver
implements RefreshableVerificationKeyResolver {
    private static final Logger LOG = Logger.getLogger(OidcProvider.class);
    final OidcTenantConfig oidcConfig;
    final Set<String> thumbprints;
    final Optional<String> expectedLeafCertificateName;
    final List<TokenCertificateValidator> certificateValidators;

    public CertChainPublicKeyResolver(OidcTenantConfig oidcConfig) {
        this.oidcConfig = oidcConfig;
        if (oidcConfig.certificateChain.getTrustStorePassword().isEmpty()) {
            throw new ConfigurationException("Truststore with configured password which keeps thumbprints of the trusted certificates must be present");
        }
        this.thumbprints = TrustStoreUtils.getTrustedCertificateThumbprints(oidcConfig.certificateChain.trustStoreFile.get(), oidcConfig.certificateChain.getTrustStorePassword().get(), oidcConfig.certificateChain.trustStoreCertAlias, oidcConfig.certificateChain.getTrustStoreFileType());
        this.expectedLeafCertificateName = oidcConfig.certificateChain.leafCertificateName;
        this.certificateValidators = TenantFeatureFinder.find(oidcConfig, TokenCertificateValidator.class);
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        try {
            List chain = jws.getCertificateChainHeaderValue();
            if (chain == null) {
                LOG.debug((Object)"Token does not have an 'x5c' certificate chain header");
                return null;
            }
            if (chain.size() == 0) {
                LOG.debug((Object)"Token 'x5c' certificate chain is empty");
                return null;
            }
            CertificateHelper.checkValidity((List)chain, null);
            if (chain.size() == 1) {
                X509Certificate root = (X509Certificate)chain.get(0);
                root.verify(root.getPublicKey());
            }
            LOG.debug((Object)"Checking a thumbprint of the root chain certificate");
            String rootThumbprint = TrustStoreUtils.calculateThumprint((X509Certificate)chain.get(chain.size() - 1));
            if (!this.thumbprints.contains(rootThumbprint)) {
                LOG.error((Object)"Thumprint of the root chain certificate is invalid");
                throw new UnresolvableKeyException("Thumprint of the root chain certificate is invalid");
            }
            if (!this.certificateValidators.isEmpty()) {
                LOG.debug((Object)"Running custom TokenCertificateValidators");
                for (TokenCertificateValidator validator : this.certificateValidators) {
                    validator.validate(this.oidcConfig, chain, jws.getUnverifiedPayload());
                }
            }
            if (!this.expectedLeafCertificateName.isEmpty()) {
                String leafCertificateName = HttpSecurityUtils.getCommonName((X500Principal)((X509Certificate)chain.get(0)).getSubjectX500Principal());
                if (!this.expectedLeafCertificateName.get().equals(leafCertificateName)) {
                    LOG.errorf("Wrong leaf certificate common name: %s", (Object)leafCertificateName);
                    throw new UnresolvableKeyException("Wrong leaf certificate common name");
                }
            } else if (this.certificateValidators.isEmpty()) {
                LOG.debug((Object)"Checking a thumbprint of the leaf chain certificate");
                String thumbprint = TrustStoreUtils.calculateThumprint((X509Certificate)chain.get(0));
                if (!this.thumbprints.contains(thumbprint)) {
                    LOG.error((Object)"Thumprint of the leaf chain certificate is invalid");
                    throw new UnresolvableKeyException("Thumprint of the leaf chain certificate is invalid");
                }
            }
            return ((X509Certificate)chain.get(0)).getPublicKey();
        }
        catch (UnresolvableKeyException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UnresolvableKeyException("Invalid certificate chain", (Throwable)ex);
        }
    }
}

