/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class BackChannelLogoutTokenCache {
    private OidcTenantConfig oidcConfig;
    private Map<String, CacheEntry> cacheMap = new ConcurrentHashMap<String, CacheEntry>();
    private AtomicInteger size = new AtomicInteger();

    public BackChannelLogoutTokenCache(OidcTenantConfig oidcTenantConfig, Vertx vertx) {
        this.oidcConfig = oidcTenantConfig;
        this.init(vertx);
    }

    private void init(Vertx vertx) {
        this.cacheMap = new ConcurrentHashMap<String, CacheEntry>();
        if (this.oidcConfig.logout.backchannel.cleanUpTimerInterval.isPresent()) {
            vertx.setPeriodic(this.oidcConfig.logout.backchannel.cleanUpTimerInterval.get().toMillis(), (Handler)new Handler<Long>(){

                public void handle(Long event) {
                    BackChannelLogoutTokenCache.this.removeInvalidEntries();
                }
            });
        }
    }

    public void addTokenVerification(String token, TokenVerificationResult result) {
        if (!this.prepareSpaceForNewCacheEntry()) {
            this.clearCache();
        }
        this.cacheMap.put(token, new CacheEntry(result));
    }

    public TokenVerificationResult removeTokenVerification(String token) {
        CacheEntry entry = this.removeCacheEntry(token);
        return entry == null ? null : entry.result;
    }

    public boolean containsTokenVerification(String token) {
        return this.cacheMap.containsKey(token);
    }

    public void clearCache() {
        this.cacheMap.clear();
        this.size.set(0);
    }

    private void removeInvalidEntries() {
        long now = BackChannelLogoutTokenCache.now();
        Iterator<Map.Entry<String, CacheEntry>> it = this.cacheMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, CacheEntry> next = it.next();
            if (!this.isEntryExpired(next.getValue(), now)) continue;
            it.remove();
            this.size.decrementAndGet();
        }
    }

    private boolean prepareSpaceForNewCacheEntry() {
        int currentSize;
        do {
            if ((currentSize = this.size.get()) != this.oidcConfig.logout.backchannel.tokenCacheSize) continue;
            return false;
        } while (!this.size.compareAndSet(currentSize, currentSize + 1));
        return true;
    }

    private CacheEntry removeCacheEntry(String token) {
        CacheEntry entry = this.cacheMap.remove(token);
        if (entry != null) {
            this.size.decrementAndGet();
        }
        return entry;
    }

    private boolean isEntryExpired(CacheEntry entry, long now) {
        return entry.createdTime + this.oidcConfig.logout.backchannel.tokenCacheTimeToLive.toMillis() < now;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static class CacheEntry {
        volatile TokenVerificationResult result;
        long createdTime = System.currentTimeMillis();

        public CacheEntry(TokenVerificationResult result) {
            this.result = result;
        }
    }
}

