/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.runtime.CertChainPublicKeyResolver;
import io.quarkus.oidc.runtime.JsonWebKeySet;
import io.quarkus.oidc.runtime.MemoryCache;
import io.quarkus.oidc.runtime.OidcProviderClient;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.security.credential.TokenCredential;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.event.Observes;
import java.security.Key;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public class DynamicVerificationKeyResolver {
    private static final Logger LOG = Logger.getLogger(DynamicVerificationKeyResolver.class);
    private static final Set<String> KEY_HEADERS = Set.of("kid", "x5t#S256", "x5t");
    private final OidcProviderClient client;
    private final MemoryCache<Key> cache;
    final CertChainPublicKeyResolver chainResolverFallback;

    public DynamicVerificationKeyResolver(OidcProviderClient client, OidcTenantConfig config) {
        this.client = client;
        this.cache = new MemoryCache(client.getVertx(), config.jwks.cleanUpTimerInterval, config.jwks.cacheTimeToLive, config.jwks.cacheSize);
        this.chainResolverFallback = config.certificateChain.trustStoreFile.isPresent() ? new CertChainPublicKeyResolver(config.certificateChain) : null;
    }

    public Uni<VerificationKeyResolver> resolve(TokenCredential tokenCred) {
        final JsonObject headers = OidcUtils.decodeJwtHeaders(tokenCred.getToken());
        Key key = this.findKeyInTheCache(headers);
        if (key != null) {
            return Uni.createFrom().item((Object)new SingleKeyVerificationKeyResolver(key));
        }
        if (this.chainResolverFallback != null && headers.containsKey("x5c") && Collections.disjoint(KEY_HEADERS, headers.fieldNames())) {
            return this.getChainResolver();
        }
        return this.client.getJsonWebKeySet(new OidcRequestContextProperties(Map.of(OidcRequestContextProperties.TOKEN, tokenCred.getToken(), OidcRequestContextProperties.TOKEN_CREDENTIAL, tokenCred))).onItem().transformToUni((Function)new Function<JsonWebKeySet, Uni<? extends VerificationKeyResolver>>(){

            @Override
            public Uni<? extends VerificationKeyResolver> apply(JsonWebKeySet jwks) {
                Key newKey = null;
                String kid = headers.getString("kid");
                if (kid != null) {
                    newKey = DynamicVerificationKeyResolver.getKeyWithId(jwks, kid);
                    if (newKey == null) {
                        return Uni.createFrom().failure((Throwable)new UnresolvableKeyException(String.format("JWK with kid '%s' is not available", kid)));
                    }
                    DynamicVerificationKeyResolver.this.cache.add(kid, newKey);
                }
                String thumbprint = null;
                if (newKey == null && (thumbprint = headers.getString("x5t#S256")) != null) {
                    newKey = DynamicVerificationKeyResolver.this.getKeyWithS256Thumbprint(jwks, thumbprint);
                    if (newKey == null) {
                        return Uni.createFrom().failure((Throwable)new UnresolvableKeyException(String.format("JWK with the SHA256 certificate thumbprint '%s' is not available", thumbprint)));
                    }
                    DynamicVerificationKeyResolver.this.cache.add(thumbprint, newKey);
                }
                if (newKey == null && (thumbprint = headers.getString("x5t")) != null) {
                    newKey = DynamicVerificationKeyResolver.this.getKeyWithThumbprint(jwks, thumbprint);
                    if (newKey == null) {
                        return Uni.createFrom().failure((Throwable)new UnresolvableKeyException(String.format("JWK with the certificate thumbprint '%s' is not available", thumbprint)));
                    }
                    DynamicVerificationKeyResolver.this.cache.add(thumbprint, newKey);
                }
                if (newKey == null && kid == null && thumbprint == null) {
                    newKey = jwks.getKeyWithoutKeyIdAndThumbprint("RSA");
                }
                if (newKey == null && DynamicVerificationKeyResolver.this.chainResolverFallback != null) {
                    return DynamicVerificationKeyResolver.this.getChainResolver();
                }
                if (newKey == null) {
                    return Uni.createFrom().failure((Throwable)new UnresolvableKeyException("JWK is not available, neither 'kid' nor 'x5t#S256' nor 'x5t' token headers are set"));
                }
                return Uni.createFrom().item((Object)new SingleKeyVerificationKeyResolver(newKey));
            }
        });
    }

    private Uni<VerificationKeyResolver> getChainResolver() {
        LOG.debug((Object)"JWK is not available, neither 'kid' nor 'x5t#S256' nor 'x5t' token headers are set, falling back to the certificate chain resolver");
        return Uni.createFrom().item((Object)this.chainResolverFallback);
    }

    private static Key getKeyWithId(JsonWebKeySet jwks, String kid) {
        if (kid != null) {
            return jwks.getKeyWithId(kid);
        }
        LOG.debug((Object)"Token 'kid' header is not set");
        return null;
    }

    private Key getKeyWithThumbprint(JsonWebKeySet jwks, String thumbprint) {
        if (thumbprint != null) {
            return jwks.getKeyWithThumbprint(thumbprint);
        }
        LOG.debug((Object)"Token 'x5t' header is not set");
        return null;
    }

    private Key getKeyWithS256Thumbprint(JsonWebKeySet jwks, String thumbprint) {
        if (thumbprint != null) {
            return jwks.getKeyWithS256Thumbprint(thumbprint);
        }
        LOG.debug((Object)"Token 'x5tS256' header is not set");
        return null;
    }

    private Key findKeyInTheCache(JsonObject headers) {
        String kid = headers.getString("kid");
        if (kid != null && this.cache.containsKey(kid)) {
            return this.cache.get(kid);
        }
        String thumbprint = headers.getString("x5t#S256");
        if (thumbprint != null && this.cache.containsKey(thumbprint)) {
            return this.cache.get(thumbprint);
        }
        thumbprint = headers.getString("x5t");
        if (thumbprint != null && this.cache.containsKey(thumbprint)) {
            return this.cache.get(thumbprint);
        }
        return null;
    }

    void shutdown(@Observes ShutdownEvent event, Vertx vertx) {
        this.cache.stopTimer(vertx);
    }

    static class SingleKeyVerificationKeyResolver
    implements VerificationKeyResolver {
        private Key key;

        SingleKeyVerificationKeyResolver(Key key) {
            this.key = key;
        }

        public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
            return this.key;
        }
    }
}

