/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.logging.Log;
import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenCustomizer;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.AbstractJsonObjectResponse;
import io.quarkus.oidc.runtime.CertChainPublicKeyResolver;
import io.quarkus.oidc.runtime.DynamicVerificationKeyResolver;
import io.quarkus.oidc.runtime.JsonWebKeySet;
import io.quarkus.oidc.runtime.OidcProviderClient;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.RefreshableVerificationKeyResolver;
import io.quarkus.oidc.runtime.TokenCustomizerFinder;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.TokenCredential;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.mutiny.Uni;
import jakarta.json.JsonObject;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwt.consumer.Validator;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.UnresolvableKeyException;

public class OidcProvider
implements Closeable {
    private static final Logger LOG = Logger.getLogger(OidcProvider.class);
    private static final String ANY_ISSUER = "any";
    private static final String ANY_AUDIENCE = "any";
    private static final String[] ASYMMETRIC_SUPPORTED_ALGORITHMS = new String[]{SignatureAlgorithm.RS256.getAlgorithm(), SignatureAlgorithm.RS384.getAlgorithm(), SignatureAlgorithm.RS512.getAlgorithm(), SignatureAlgorithm.ES256.getAlgorithm(), SignatureAlgorithm.ES384.getAlgorithm(), SignatureAlgorithm.ES512.getAlgorithm(), SignatureAlgorithm.PS256.getAlgorithm(), SignatureAlgorithm.PS384.getAlgorithm(), SignatureAlgorithm.PS512.getAlgorithm(), SignatureAlgorithm.EDDSA.getAlgorithm()};
    private static final AlgorithmConstraints ASYMMETRIC_ALGORITHM_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, ASYMMETRIC_SUPPORTED_ALGORITHMS);
    private static final AlgorithmConstraints SYMMETRIC_ALGORITHM_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{SignatureAlgorithm.HS256.getAlgorithm()});
    final OidcProviderClient client;
    final RefreshableVerificationKeyResolver asymmetricKeyResolver;
    final DynamicVerificationKeyResolver keyResolverProvider;
    final OidcTenantConfig oidcConfig;
    final TokenCustomizer tokenCustomizer;
    final String issuer;
    final String[] audience;
    final Map<String, String> requiredClaims;
    final Key tokenDecryptionKey;
    final AlgorithmConstraints requiredAlgorithmConstraints;

    public OidcProvider(OidcProviderClient client, OidcTenantConfig oidcConfig, JsonWebKeySet jwks, Key tokenDecryptionKey) {
        this(client, oidcConfig, jwks, TokenCustomizerFinder.find(oidcConfig), tokenDecryptionKey);
    }

    public OidcProvider(OidcProviderClient client, OidcTenantConfig oidcConfig, JsonWebKeySet jwks, TokenCustomizer tokenCustomizer, Key tokenDecryptionKey) {
        this.client = client;
        this.oidcConfig = oidcConfig;
        this.tokenCustomizer = tokenCustomizer;
        this.asymmetricKeyResolver = jwks != null ? new JsonWebKeyResolver(jwks, oidcConfig.token.forcedJwkRefreshInterval, oidcConfig.certificateChain) : (oidcConfig != null && oidcConfig.certificateChain.trustStoreFile.isPresent() ? new CertChainPublicKeyResolver(oidcConfig.certificateChain) : null);
        this.keyResolverProvider = client != null && oidcConfig != null && !oidcConfig.jwks.resolveEarly ? new DynamicVerificationKeyResolver(client, oidcConfig) : null;
        this.issuer = this.checkIssuerProp();
        this.audience = this.checkAudienceProp();
        this.requiredClaims = this.checkRequiredClaimsProp();
        this.tokenDecryptionKey = tokenDecryptionKey;
        this.requiredAlgorithmConstraints = this.checkSignatureAlgorithm();
    }

    public OidcProvider(String publicKeyEnc, OidcTenantConfig oidcConfig, Key tokenDecryptionKey) {
        this.client = null;
        this.oidcConfig = oidcConfig;
        this.tokenCustomizer = TokenCustomizerFinder.find(oidcConfig);
        if (publicKeyEnc != null) {
            this.asymmetricKeyResolver = new LocalPublicKeyResolver(publicKeyEnc);
        } else if (oidcConfig.certificateChain.trustStoreFile.isPresent()) {
            this.asymmetricKeyResolver = new CertChainPublicKeyResolver(oidcConfig.certificateChain);
        } else {
            throw new IllegalStateException("Neither public key nor certificate chain verification modes are enabled");
        }
        this.keyResolverProvider = null;
        this.issuer = this.checkIssuerProp();
        this.audience = this.checkAudienceProp();
        this.requiredClaims = this.checkRequiredClaimsProp();
        this.tokenDecryptionKey = tokenDecryptionKey;
        this.requiredAlgorithmConstraints = this.checkSignatureAlgorithm();
    }

    private AlgorithmConstraints checkSignatureAlgorithm() {
        if (this.oidcConfig != null && this.oidcConfig.token.signatureAlgorithm.isPresent()) {
            String configuredAlg = this.oidcConfig.token.signatureAlgorithm.get().getAlgorithm();
            return new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{configuredAlg});
        }
        return null;
    }

    private String checkIssuerProp() {
        String issuerProp = null;
        if (this.oidcConfig != null && (issuerProp = (String)this.oidcConfig.token.issuer.orElse(null)) == null && this.client != null) {
            issuerProp = this.client.getMetadata().getIssuer();
        }
        return "any".equals(issuerProp) ? null : issuerProp;
    }

    private String[] checkAudienceProp() {
        List audienceProp = this.oidcConfig != null ? (List)this.oidcConfig.token.audience.orElse(null) : null;
        return audienceProp != null ? audienceProp.toArray(new String[0]) : null;
    }

    private Map<String, String> checkRequiredClaimsProp() {
        return this.oidcConfig != null ? this.oidcConfig.token.requiredClaims : null;
    }

    public TokenVerificationResult verifySelfSignedJwtToken(String token) throws InvalidJwtException {
        return this.verifyJwtTokenInternal(token, true, false, null, SYMMETRIC_ALGORITHM_CONSTRAINTS, new SymmetricKeyResolver(), true);
    }

    public TokenVerificationResult verifyJwtToken(String token, boolean enforceAudienceVerification, boolean subjectRequired, String nonce) throws InvalidJwtException {
        return this.verifyJwtTokenInternal(this.customizeJwtToken(token), enforceAudienceVerification, subjectRequired, nonce, this.requiredAlgorithmConstraints != null ? this.requiredAlgorithmConstraints : ASYMMETRIC_ALGORITHM_CONSTRAINTS, this.asymmetricKeyResolver, true);
    }

    public TokenVerificationResult verifyLogoutJwtToken(String token) throws InvalidJwtException {
        boolean enforceExpReq = !this.oidcConfig.token.age.isPresent();
        TokenVerificationResult result = this.verifyJwtTokenInternal(token, true, false, null, ASYMMETRIC_ALGORITHM_CONSTRAINTS, this.asymmetricKeyResolver, enforceExpReq);
        if (!enforceExpReq && this.isTokenExpired(result.localVerificationResult.getLong(Claims.exp.name()))) {
            String error = String.format("Logout token for client %s has expired", this.oidcConfig.clientId.get());
            LOG.debugf(error, new Object[0]);
            throw new InvalidJwtException(error, List.of(new ErrorCodeValidator.Error(1, error)), null);
        }
        return result;
    }

    private TokenVerificationResult verifyJwtTokenInternal(String token, boolean enforceAudienceVerification, boolean subjectRequired, String nonce, AlgorithmConstraints algConstraints, VerificationKeyResolver verificationKeyResolver, boolean enforceExpReq) throws InvalidJwtException {
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setVerificationKeyResolver(verificationKeyResolver);
        builder.setJwsAlgorithmConstraints(algConstraints);
        if (enforceExpReq) {
            builder.setRequireExpirationTime();
        }
        if (subjectRequired) {
            builder.setRequireSubject();
        }
        if (nonce != null) {
            builder.registerValidator((Validator)new CustomClaimsValidator(Map.of("nonce", nonce)));
        }
        builder.setRequireIssuedAt();
        if (this.issuer != null) {
            builder.setExpectedIssuer(this.issuer);
        }
        if (this.audience != null) {
            if (this.audience.length == 1 && this.audience[0].equals("any")) {
                builder.setSkipDefaultAudienceValidation();
            } else {
                builder.setExpectedAudience(this.audience);
            }
        } else if (enforceAudienceVerification) {
            builder.setExpectedAudience(new String[]{(String)this.oidcConfig.clientId.get()});
        } else {
            builder.setSkipDefaultAudienceValidation();
        }
        if (this.requiredClaims != null && !this.requiredClaims.isEmpty()) {
            builder.registerValidator((Validator)new CustomClaimsValidator(this.requiredClaims));
        }
        if (this.oidcConfig.token.lifespanGrace.isPresent()) {
            int lifespanGrace = this.oidcConfig.token.lifespanGrace.getAsInt();
            builder.setAllowedClockSkewInSeconds(lifespanGrace);
        }
        builder.setRelaxVerificationKeyValidation();
        try {
            JwtConsumer jwtConsumer = builder.build();
            jwtConsumer.processToClaims(token);
        }
        catch (InvalidJwtException ex) {
            String detail = "";
            List details = ex.getErrorDetails();
            if (!details.isEmpty()) {
                detail = ((ErrorCodeValidator.Error)details.get(0)).getErrorMessage();
            }
            if (this.oidcConfig.clientId.isPresent()) {
                LOG.debugf("Verification of the token issued to client %s has failed: %s", this.oidcConfig.clientId.get(), (Object)detail);
            } else {
                LOG.debugf("Token verification has failed: %s", (Object)detail);
            }
            throw ex;
        }
        TokenVerificationResult result = new TokenVerificationResult(OidcUtils.decodeJwtContent(token), null);
        this.verifyTokenAge(result.localVerificationResult.getLong(Claims.iat.name()));
        return result;
    }

    private String customizeJwtToken(String token) {
        if (this.tokenCustomizer != null) {
            JsonObject headers = AbstractJsonObjectResponse.toJsonObject(OidcUtils.decodeJwtHeadersAsString(token));
            if ((headers = this.tokenCustomizer.customizeHeaders(headers)) != null) {
                String newHeaders = new String(Base64.getUrlEncoder().withoutPadding().encode(headers.toString().getBytes()), StandardCharsets.UTF_8);
                int dotIndex = token.indexOf(46);
                String newToken = newHeaders + token.substring(dotIndex);
                return newToken;
            }
        }
        return token;
    }

    private void verifyTokenAge(Long iat) throws InvalidJwtException {
        long now;
        if (this.oidcConfig.token.age.isPresent() && iat != null && (now = OidcProvider.now() / 1000L) - iat > this.oidcConfig.token.age.get().toSeconds() + (long)this.getLifespanGrace()) {
            String errorMessage = "Token age exceeds the configured token age property";
            LOG.debugf("Token age exceeds the configured token age property", new Object[0]);
            throw new InvalidJwtException("Token age exceeds the configured token age property", List.of(new ErrorCodeValidator.Error(24, "Token age exceeds the configured token age property")), null);
        }
    }

    public Uni<TokenVerificationResult> refreshJwksAndVerifyJwtToken(final String token, final boolean enforceAudienceVerification, final boolean subjectRequired, final String nonce) {
        return this.asymmetricKeyResolver.refresh().onItem().transformToUni((Function)new Function<Void, Uni<? extends TokenVerificationResult>>(){

            @Override
            public Uni<? extends TokenVerificationResult> apply(Void v) {
                try {
                    return Uni.createFrom().item((Object)OidcProvider.this.verifyJwtToken(token, enforceAudienceVerification, subjectRequired, nonce));
                }
                catch (Throwable t) {
                    return Uni.createFrom().failure(t);
                }
            }
        });
    }

    public Uni<TokenVerificationResult> getKeyResolverAndVerifyJwtToken(final TokenCredential tokenCred, final boolean enforceAudienceVerification, final boolean subjectRequired, final String nonce) {
        return this.keyResolverProvider.resolve(tokenCred).onItem().transformToUni((Function)new Function<VerificationKeyResolver, Uni<? extends TokenVerificationResult>>(){

            @Override
            public Uni<? extends TokenVerificationResult> apply(VerificationKeyResolver resolver) {
                try {
                    return Uni.createFrom().item((Object)OidcProvider.this.verifyJwtTokenInternal(OidcProvider.this.customizeJwtToken(tokenCred.getToken()), enforceAudienceVerification, subjectRequired, nonce, OidcProvider.this.requiredAlgorithmConstraints != null ? OidcProvider.this.requiredAlgorithmConstraints : ASYMMETRIC_ALGORITHM_CONSTRAINTS, resolver, true));
                }
                catch (Throwable t) {
                    return Uni.createFrom().failure(t);
                }
            }
        });
    }

    public Uni<TokenIntrospection> introspectToken(String token, boolean fallbackFromJwkMatch) {
        if (this.client.getMetadata().getIntrospectionUri() == null) {
            String errorMessage = String.format("Token issued to client %s " + (fallbackFromJwkMatch ? "does not have a matching verification key and it " : "") + "can not be introspected because the introspection endpoint address is unknown - please check if your OpenId Connect Provider supports the token introspection", this.oidcConfig.clientId.get());
            throw new AuthenticationFailedException(errorMessage);
        }
        return this.client.introspectToken(token).onItemOrFailure().transform((BiFunction)new BiFunction<TokenIntrospection, Throwable, TokenIntrospection>(){

            @Override
            public TokenIntrospection apply(TokenIntrospection introspectionResult, Throwable t) {
                if (t != null) {
                    throw new AuthenticationFailedException(t);
                }
                if (!introspectionResult.isActive()) {
                    this.verifyTokenExpiry(introspectionResult.getLong("exp"));
                    throw new AuthenticationFailedException(String.format("Token issued to client %s is not active", OidcProvider.this.oidcConfig.clientId.get()));
                }
                this.verifyTokenExpiry(introspectionResult.getLong("exp"));
                try {
                    OidcProvider.this.verifyTokenAge(introspectionResult.getLong("iat"));
                }
                catch (InvalidJwtException ex) {
                    throw new AuthenticationFailedException((Throwable)ex);
                }
                return introspectionResult;
            }

            private void verifyTokenExpiry(Long exp) {
                if (OidcProvider.this.isTokenExpired(exp)) {
                    String error = String.format("Token issued to client %s has expired", OidcProvider.this.oidcConfig.clientId.get());
                    LOG.debugf(error, new Object[0]);
                    throw new AuthenticationFailedException((Throwable)new InvalidJwtException(error, List.of(new ErrorCodeValidator.Error(1, error)), null));
                }
            }
        });
    }

    private boolean isTokenExpired(Long exp) {
        return exp != null && OidcProvider.now() / 1000L > exp + (long)this.getLifespanGrace();
    }

    private int getLifespanGrace() {
        return this.client.getOidcConfig().token.lifespanGrace.isPresent() ? this.client.getOidcConfig().token.lifespanGrace.getAsInt() : 0;
    }

    private static final long now() {
        return System.currentTimeMillis();
    }

    public Uni<UserInfo> getUserInfo(String accessToken) {
        return this.client.getUserInfo(accessToken);
    }

    public Uni<AuthorizationCodeTokens> getCodeFlowTokens(String code, String redirectUri, String codeVerifier) {
        return this.client.getAuthorizationCodeTokens(code, redirectUri, codeVerifier);
    }

    public Uni<AuthorizationCodeTokens> refreshTokens(String refreshToken) {
        return this.client.refreshAuthorizationCodeTokens(refreshToken);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public OidcConfigurationMetadata getMetadata() {
        return this.client.getMetadata();
    }

    private class JsonWebKeyResolver
    implements RefreshableVerificationKeyResolver {
        volatile JsonWebKeySet jwks;
        volatile long lastForcedRefreshTime;
        volatile long forcedJwksRefreshIntervalMilliSecs;
        final CertChainPublicKeyResolver chainResolverFallback;

        JsonWebKeyResolver(JsonWebKeySet jwks, Duration forcedJwksRefreshInterval, OidcTenantConfig.CertificateChain chain) {
            this.jwks = jwks;
            this.forcedJwksRefreshIntervalMilliSecs = forcedJwksRefreshInterval.toMillis();
            this.chainResolverFallback = chain.trustStoreFile.isPresent() ? new CertChainPublicKeyResolver(chain) : null;
        }

        public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
            Key key = null;
            String kid = jws.getKeyIdHeaderValue();
            if (kid != null && (key = this.getKeyWithId(kid)) == null) {
                throw new UnresolvableKeyException(String.format("JWK with kid '%s' is not available", kid));
            }
            String thumbprint = null;
            if (key == null && (thumbprint = jws.getHeader("x5t#S256")) != null && (key = this.getKeyWithS256Thumbprint(thumbprint)) == null) {
                throw new UnresolvableKeyException(String.format("JWK with the SHA256 certificate thumbprint '%s' is not available", thumbprint));
            }
            if (key == null && (thumbprint = jws.getHeader("x5t")) != null && (key = this.getKeyWithThumbprint(thumbprint)) == null) {
                throw new UnresolvableKeyException(String.format("JWK with the certificate thumbprint '%s' is not available", thumbprint));
            }
            if (key == null && kid == null && thumbprint == null) {
                try {
                    key = this.jwks.getKeyWithoutKeyIdAndThumbprint(jws.getKeyType());
                }
                catch (InvalidAlgorithmException ex) {
                    Log.debug((Object)"Token 'alg'(algorithm) header value is invalid", (Throwable)ex);
                }
            }
            if (key == null && this.chainResolverFallback != null) {
                LOG.debug((Object)"JWK is not available, neither 'kid' nor 'x5t#S256' nor 'x5t' token headers are set, falling back to the certificate chain resolver");
                key = this.chainResolverFallback.resolveKey(jws, nestingContext);
            }
            if (key == null) {
                throw new UnresolvableKeyException("JWK is not available, neither 'kid' nor 'x5t#S256' nor 'x5t' token headers are set");
            }
            return key;
        }

        private Key getKeyWithId(String kid) {
            if (kid != null) {
                return this.jwks.getKeyWithId(kid);
            }
            LOG.debug((Object)"Token 'kid' header is not set");
            return null;
        }

        private Key getKeyWithThumbprint(String thumbprint) {
            if (thumbprint != null) {
                return this.jwks.getKeyWithThumbprint(thumbprint);
            }
            LOG.debug((Object)"Token 'x5t' header is not set");
            return null;
        }

        private Key getKeyWithS256Thumbprint(String thumbprint) {
            if (thumbprint != null) {
                return this.jwks.getKeyWithS256Thumbprint(thumbprint);
            }
            LOG.debug((Object)"Token 'x5tS256' header is not set");
            return null;
        }

        @Override
        public Uni<Void> refresh() {
            long now = OidcProvider.now();
            if (now > this.lastForcedRefreshTime + this.forcedJwksRefreshIntervalMilliSecs) {
                this.lastForcedRefreshTime = now;
                return OidcProvider.this.client.getJsonWebKeySet((OidcRequestContextProperties)null).onItem().transformToUni((Function)new Function<JsonWebKeySet, Uni<? extends Void>>(){

                    @Override
                    public Uni<? extends Void> apply(JsonWebKeySet t) {
                        JsonWebKeyResolver.this.jwks = t;
                        return Uni.createFrom().voidItem();
                    }
                });
            }
            return Uni.createFrom().voidItem();
        }
    }

    private static class LocalPublicKeyResolver
    implements RefreshableVerificationKeyResolver {
        Key key;

        LocalPublicKeyResolver(String publicKeyEnc) {
            try {
                this.key = KeyUtils.decodePublicKey((String)publicKeyEnc);
            }
            catch (Exception ex) {
                throw new OIDCException(ex);
            }
        }

        public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
            return this.key;
        }
    }

    private class SymmetricKeyResolver
    implements VerificationKeyResolver {
        private SymmetricKeyResolver() {
        }

        public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
            return KeyUtils.createSecretKeyFromSecret((String)OidcCommonUtils.clientSecret((OidcCommonConfig.Credentials)OidcProvider.this.oidcConfig.credentials));
        }
    }

    private static class CustomClaimsValidator
    implements Validator {
        private final Map<String, String> customClaims;

        public CustomClaimsValidator(Map<String, String> customClaims) {
            this.customClaims = customClaims;
        }

        public String validate(JwtContext jwtContext) throws MalformedClaimException {
            JwtClaims claims = jwtContext.getJwtClaims();
            for (Map.Entry<String, String> targetClaim : this.customClaims.entrySet()) {
                String targetValue;
                String claimName = targetClaim.getKey();
                if (!claims.hasClaim(claimName)) {
                    return "claim " + claimName + " is missing";
                }
                if (!claims.isClaimValueString(claimName)) {
                    throw new MalformedClaimException("expected claim " + claimName + " to be a string");
                }
                String claimValue = claims.getStringClaimValue(claimName);
                if (claimValue.equals(targetValue = targetClaim.getValue())) continue;
                return "claim " + claimName + "does not match expected value of " + targetValue;
            }
            return null;
        }
    }
}

