/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.qute.deployment.CheckedTemplateAdapter;
import io.quarkus.qute.runtime.TemplateProducer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class NativeCheckedTemplateEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private final Map<String, NativeMethod> methods = new HashMap<String, NativeMethod>();

    public void implement(MethodInfo methodInfo, String templatePath, String fragmentId, List<String> parameterNames, CheckedTemplateAdapter adaptor) {
        this.methods.put(methodInfo.name(), new NativeMethod(methodInfo, templatePath, fragmentId, parameterNames, adaptor));
    }

    @Override
    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new DynamicTemplateClassVisitor(className, this.methods, outputClassVisitor);
    }

    private static class NativeMethod {
        private final MethodInfo methodInfo;
        private final String templateId;
        private final String fragmentId;
        private final List<String> parameterNames;
        private final CheckedTemplateAdapter adaptor;

        public NativeMethod(MethodInfo methodInfo, String templatePath, String fragmentId, List<String> parameterNames, CheckedTemplateAdapter adaptor) {
            this.methodInfo = methodInfo;
            this.templateId = templatePath;
            this.fragmentId = fragmentId;
            this.parameterNames = parameterNames;
            this.adaptor = adaptor;
        }
    }

    public static class DynamicTemplateClassVisitor
    extends ClassVisitor {
        private final Map<String, NativeMethod> methods;

        public DynamicTemplateClassVisitor(String className, Map<String, NativeMethod> methods, ClassVisitor outputClassVisitor) {
            super(589824, outputClassVisitor);
            this.methods = methods;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            NativeMethod nativeMethod = this.methods.get(name);
            if (nativeMethod != null) {
                access &= 0xFFFFFEFF;
            }
            MethodVisitor ret = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (nativeMethod != null) {
                return new NativeMethodVisitor(nativeMethod, ret);
            }
            return ret;
        }

        public static class NativeMethodVisitor
        extends MethodVisitor {
            private NativeMethod nativeMethod;

            public NativeMethodVisitor(NativeMethod nativeMethod, MethodVisitor outputVisitor) {
                super(589824, outputVisitor);
                this.nativeMethod = nativeMethod;
            }

            public void visitEnd() {
                this.visitCode();
                this.visitMethodInsn(184, "io/quarkus/arc/Arc", "container", "()Lio/quarkus/arc/ArcContainer;", false);
                this.visitLdcInsn(org.objectweb.asm.Type.getType(TemplateProducer.class));
                this.visitLdcInsn(0);
                this.visitTypeInsn(189, "java/lang/annotation/Annotation");
                this.visitMethodInsn(185, "io/quarkus/arc/ArcContainer", "instance", "(Ljava/lang/Class;[Ljava/lang/annotation/Annotation;)Lio/quarkus/arc/InstanceHandle;", true);
                this.visitMethodInsn(185, "io/quarkus/arc/InstanceHandle", "get", "()Ljava/lang/Object;", true);
                this.visitTypeInsn(192, "io/quarkus/qute/runtime/TemplateProducer");
                this.visitLdcInsn(this.nativeMethod.templateId);
                this.visitMethodInsn(182, "io/quarkus/qute/runtime/TemplateProducer", "getInjectableTemplate", "(Ljava/lang/String;)Lio/quarkus/qute/Template;", false);
                if (this.nativeMethod.fragmentId != null) {
                    this.visitLdcInsn(this.nativeMethod.fragmentId);
                    this.visitMethodInsn(185, "io/quarkus/qute/Template", "getFragment", "(Ljava/lang/String;)Lio/quarkus/qute/Template$Fragment;", true);
                }
                this.visitMethodInsn(185, "io/quarkus/qute/Template", "instance", "()Lio/quarkus/qute/TemplateInstance;", true);
                String templateInstanceBinaryName = "io/quarkus/qute/TemplateInstance";
                if (this.nativeMethod.adaptor != null) {
                    this.nativeMethod.adaptor.convertTemplateInstance(this);
                    templateInstanceBinaryName = this.nativeMethod.adaptor.templateInstanceBinaryName();
                }
                int slot = 0;
                List parameters = this.nativeMethod.methodInfo.parameterTypes();
                for (int i = 0; i < this.nativeMethod.parameterNames.size(); ++i) {
                    Type parameterType = (Type)parameters.get(i);
                    this.visitLdcInsn(this.nativeMethod.parameterNames.get(i));
                    this.visitVarInsn(AsmUtil.getLoadOpcode((Type)parameterType), slot);
                    AsmUtil.boxIfRequired((MethodVisitor)this, (Type)parameterType);
                    this.visitMethodInsn(185, templateInstanceBinaryName, "data", "(Ljava/lang/String;Ljava/lang/Object;)L" + templateInstanceBinaryName + ";", true);
                    slot += AsmUtil.getParameterSize((Type)parameterType);
                }
                this.visitInsn(176);
                this.visitMaxs(0, 0);
                super.visitEnd();
            }
        }
    }
}

