/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import javax.enterprise.inject.spi.CDI;

@Recorder
public class HttpSecurityRecorder {
    public Handler<RoutingContext> authenticationMechanismHandler() {
        return new Handler<RoutingContext>(){

            public void handle(final RoutingContext event) {
                final HttpAuthenticator authenticator = (HttpAuthenticator)CDI.current().select(HttpAuthenticator.class, new Annotation[0]).get();
                event.put(HttpAuthenticator.class.getName(), (Object)authenticator);
                authenticator.attemptAuthentication(event).handle(new BiFunction<SecurityIdentity, Throwable, Object>(){

                    @Override
                    public Object apply(SecurityIdentity identity, Throwable throwable) {
                        if (throwable != null) {
                            while (throwable instanceof CompletionException && throwable.getCause() != null) {
                                throwable = throwable.getCause();
                            }
                            if (throwable instanceof AuthenticationFailedException) {
                                authenticator.sendChallenge(event, new Runnable(){

                                    @Override
                                    public void run() {
                                        event.response().end();
                                    }
                                });
                            } else {
                                event.fail(throwable);
                            }
                            return null;
                        }
                        if (identity != null) {
                            event.setUser((User)new QuarkusHttpUser(identity));
                        }
                        event.next();
                        return null;
                    }
                });
            }
        };
    }
}

