/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HttpAuthorizer {
    @Inject
    HttpAuthenticator httpAuthenticator;
    @Inject
    IdentityProviderManager identityProviderManager;
    final List<HttpSecurityPolicy> policies = new ArrayList<HttpSecurityPolicy>();
    private static final HttpSecurityPolicy.AuthorizationRequestContext CONTEXT = new HttpSecurityPolicy.AuthorizationRequestContext(){

        @Override
        public CompletionStage<HttpSecurityPolicy.CheckResult> runBlocking(final RoutingContext context, final SecurityIdentity identity, final BiFunction<RoutingContext, SecurityIdentity, HttpSecurityPolicy.CheckResult> function) {
            if (BlockingOperationControl.isBlockingAllowed()) {
                try {
                    HttpSecurityPolicy.CheckResult res = function.apply(context, identity);
                    return CompletableFuture.completedFuture(res);
                }
                catch (Throwable t) {
                    CompletableFuture<HttpSecurityPolicy.CheckResult> res = new CompletableFuture<HttpSecurityPolicy.CheckResult>();
                    res.completeExceptionally(t);
                    return res;
                }
            }
            try {
                final CompletableFuture<HttpSecurityPolicy.CheckResult> res = new CompletableFuture<HttpSecurityPolicy.CheckResult>();
                ExecutorRecorder.getCurrent().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HttpSecurityPolicy.CheckResult val = (HttpSecurityPolicy.CheckResult)function.apply(context, identity);
                            res.complete(val);
                        }
                        catch (Throwable t) {
                            res.completeExceptionally(t);
                        }
                    }
                });
                return res;
            }
            catch (Exception e) {
                CompletableFuture<HttpSecurityPolicy.CheckResult> res = new CompletableFuture<HttpSecurityPolicy.CheckResult>();
                res.completeExceptionally(e);
                return res;
            }
        }
    };

    @Inject
    HttpAuthorizer(Instance<HttpSecurityPolicy> installedPolicies) {
        for (HttpSecurityPolicy i : installedPolicies) {
            this.policies.add(i);
        }
    }

    public void checkPermission(RoutingContext routingContext) {
        QuarkusHttpUser user = (QuarkusHttpUser)routingContext.user();
        if (user == null) {
            this.attemptAnonymousAuthentication(routingContext);
        } else {
            this.doPermissionCheck(routingContext, user.getSecurityIdentity(), 0, this.policies);
        }
    }

    private void attemptAnonymousAuthentication(final RoutingContext routingContext) {
        this.identityProviderManager.authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE).handle(new BiFunction<SecurityIdentity, Throwable, Object>(){

            @Override
            public Object apply(SecurityIdentity identity, Throwable throwable) {
                if (throwable != null) {
                    routingContext.fail(throwable);
                } else {
                    HttpAuthorizer.this.doPermissionCheck(routingContext, identity, 0, HttpAuthorizer.this.policies);
                }
                return null;
            }
        });
    }

    private void doPermissionCheck(final RoutingContext routingContext, final SecurityIdentity identity, final int index, final List<HttpSecurityPolicy> permissionCheckers) {
        if (index == permissionCheckers.size()) {
            QuarkusHttpUser currentUser = (QuarkusHttpUser)routingContext.user();
            if (!(identity.isAnonymous() || currentUser != null && currentUser.getSecurityIdentity() == identity)) {
                routingContext.setUser((User)new QuarkusHttpUser(identity));
            }
            routingContext.next();
            return;
        }
        HttpSecurityPolicy res = permissionCheckers.get(index);
        res.checkPermission(routingContext, identity, CONTEXT).handle(new BiFunction<HttpSecurityPolicy.CheckResult, Throwable, Object>(){

            @Override
            public Object apply(HttpSecurityPolicy.CheckResult checkResult, Throwable throwable) {
                if (throwable != null) {
                    routingContext.fail(throwable);
                } else if (!checkResult.isPermitted()) {
                    HttpAuthorizer.this.doDeny(identity, routingContext);
                } else {
                    SecurityIdentity newIdentity = checkResult.getAugmentedIdentity() != null ? checkResult.getAugmentedIdentity() : identity;
                    HttpAuthorizer.this.doPermissionCheck(routingContext, newIdentity, index + 1, permissionCheckers);
                }
                return null;
            }
        });
    }

    private void doDeny(SecurityIdentity identity, final RoutingContext routingContext) {
        if (identity.isAnonymous()) {
            this.httpAuthenticator.sendChallenge(routingContext, new Runnable(){

                @Override
                public void run() {
                    routingContext.response().end();
                }
            });
        } else {
            routingContext.fail(403);
        }
    }
}

