/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.util.AsciiString;
import io.quarkus.vertx.http.runtime.ForwardingProxyOptions;
import io.quarkus.vertx.http.runtime.TrustedProxyCheck;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

class ForwardedParser {
    private static final Logger log = Logger.getLogger(ForwardedParser.class);
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final AsciiString FORWARDED = AsciiString.cached((String)"Forwarded");
    private static final AsciiString X_FORWARDED_SSL = AsciiString.cached((String)"X-Forwarded-Ssl");
    private static final AsciiString X_FORWARDED_PROTO = AsciiString.cached((String)"X-Forwarded-Proto");
    private static final AsciiString X_FORWARDED_PORT = AsciiString.cached((String)"X-Forwarded-Port");
    private static final AsciiString X_FORWARDED_FOR = AsciiString.cached((String)"X-Forwarded-For");
    private static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("host=\"?([^;,\"]+)\"?");
    private static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("proto=\"?([^;,\"]+)\"?");
    private static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("for=\"?([^;,\"]+)\"?");
    private static final int PORT_MIN_VALID_VALUE = 0;
    private static final int PORT_MAX_VALID_VALUE = 65535;
    private final HttpServerRequest delegate;
    private final ForwardingProxyOptions forwardingProxyOptions;
    private final TrustedProxyCheck trustedProxyCheck;
    private boolean calculated;
    private String host;
    private int port = -1;
    private String scheme;
    private String uri;
    private String absoluteURI;
    private SocketAddress remoteAddress;
    private HostAndPort authority;

    ForwardedParser(HttpServerRequest delegate, ForwardingProxyOptions forwardingProxyOptions, TrustedProxyCheck trustedProxyCheck) {
        this.delegate = delegate;
        this.forwardingProxyOptions = forwardingProxyOptions;
        this.trustedProxyCheck = trustedProxyCheck;
    }

    public String scheme() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.scheme;
    }

    String host() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.host;
    }

    boolean isSSL() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.scheme.equals(HTTPS_SCHEME);
    }

    HostAndPort authority() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.authority;
    }

    String absoluteURI() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.absoluteURI;
    }

    SocketAddress remoteAddress() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.remoteAddress;
    }

    String uri() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.uri;
    }

    private void calculate() {
        this.calculated = true;
        this.remoteAddress = this.delegate.remoteAddress();
        this.scheme = this.delegate.scheme();
        this.setHostAndPort(this.delegate.getHeader(HttpHeaders.HOST), this.port);
        this.uri = this.delegate.uri();
        if (this.trustedProxyCheck.isProxyAllowed()) {
            String forwarded = this.delegate.getHeader((CharSequence)FORWARDED);
            if (this.forwardingProxyOptions.allowForwarded && forwarded != null) {
                Matcher matcher = FORWARDED_PROTO_PATTERN.matcher(forwarded);
                if (matcher.find()) {
                    this.scheme = matcher.group(1).trim();
                    this.port = -1;
                }
                if ((matcher = FORWARDED_HOST_PATTERN.matcher(forwarded)).find()) {
                    this.setHostAndPort(matcher.group(1).trim(), this.port);
                }
                if ((matcher = FORWARDED_FOR_PATTERN.matcher(forwarded)).find()) {
                    this.remoteAddress = this.parseFor(matcher.group(1).trim(), this.remoteAddress.port());
                }
            } else if (this.forwardingProxyOptions.allowXForwarded) {
                String forHeader;
                String portHeader;
                String prefixHeader;
                String hostHeader;
                String forwardedSsl;
                boolean isForwardedSslOn;
                String protocolHeader = this.delegate.getHeader((CharSequence)X_FORWARDED_PROTO);
                if (protocolHeader != null) {
                    this.scheme = this.getFirstElement(protocolHeader);
                    this.port = -1;
                }
                boolean bl = isForwardedSslOn = (forwardedSsl = this.delegate.getHeader((CharSequence)X_FORWARDED_SSL)) != null && forwardedSsl.equalsIgnoreCase("on");
                if (isForwardedSslOn) {
                    this.scheme = HTTPS_SCHEME;
                    this.port = -1;
                }
                if (this.forwardingProxyOptions.enableForwardedHost && (hostHeader = this.delegate.getHeader((CharSequence)this.forwardingProxyOptions.forwardedHostHeader)) != null) {
                    this.setHostAndPort(this.getFirstElement(hostHeader), this.port);
                }
                if (this.forwardingProxyOptions.enableForwardedPrefix && (prefixHeader = this.delegate.getHeader((CharSequence)this.forwardingProxyOptions.forwardedPrefixHeader)) != null) {
                    this.uri = this.appendPrefixToUri(prefixHeader, this.uri);
                }
                if ((portHeader = this.delegate.getHeader((CharSequence)X_FORWARDED_PORT)) != null) {
                    this.port = this.parsePort(this.getFirstElement(portHeader), this.port);
                }
                if ((forHeader = this.delegate.getHeader((CharSequence)X_FORWARDED_FOR)) != null) {
                    this.remoteAddress = this.parseFor(this.getFirstElement(forHeader), this.remoteAddress.port());
                }
            }
        }
        if (this.scheme.equals(HTTP_SCHEME) && this.port == 80 || this.scheme.equals(HTTPS_SCHEME) && this.port == 443) {
            this.port = -1;
        }
        this.authority = HostAndPort.create((String)this.host, (int)(this.port >= 0 ? this.port : -1));
        this.host = this.host + (String)(this.port >= 0 ? ":" + this.port : "");
        this.delegate.headers().set(HttpHeaders.HOST, (CharSequence)this.host);
        this.absoluteURI = this.scheme + "://" + this.host + this.uri;
        log.debug((Object)("Recalculated absoluteURI to " + this.absoluteURI));
    }

    private void setHostAndPort(String hostToParse, int defaultPort) {
        if (hostToParse == null) {
            hostToParse = "";
        }
        String[] hostAndPort = this.parseHostAndPort(hostToParse);
        this.host = hostAndPort[0];
        this.delegate.headers().set(HttpHeaders.HOST, (CharSequence)this.host);
        this.port = this.parsePort(hostAndPort[1], defaultPort);
    }

    private SocketAddress parseFor(String forToParse, int defaultPort) {
        String[] hostAndPort = this.parseHostAndPort(forToParse);
        String host = hostAndPort[0];
        int port = this.parsePort(hostAndPort[1], defaultPort);
        return new SocketAddressImpl(port, host);
    }

    private String getFirstElement(String value) {
        int index = value.indexOf(44);
        return index == -1 ? value : value.substring(0, index);
    }

    private String[] parseHostAndPort(String hostToParse) {
        String[] hostAndPort = new String[]{hostToParse, ""};
        int portSeparatorIdx = hostToParse.lastIndexOf(58);
        int squareBracketIdx = hostToParse.lastIndexOf(93);
        if (squareBracketIdx > -1 && portSeparatorIdx > squareBracketIdx) {
            hostAndPort[0] = hostToParse.substring(0, portSeparatorIdx);
            hostAndPort[1] = hostToParse.substring(portSeparatorIdx + 1);
        } else {
            long numberOfColons = hostToParse.chars().filter(ch -> ch == 58).count();
            if (numberOfColons == 1L && !hostToParse.endsWith(":")) {
                hostAndPort[0] = hostToParse.substring(0, portSeparatorIdx);
                hostAndPort[1] = hostToParse.substring(portSeparatorIdx + 1);
            }
        }
        return hostAndPort;
    }

    private int parsePort(String portToParse, int defaultPort) {
        if (portToParse != null && portToParse.length() > 0) {
            try {
                int port = Integer.parseInt(portToParse);
                if (port < 0 || port > 65535) {
                    log.errorf("Failed to validate a port from \"forwarded\"-type headers, using the default port %d", (Object)defaultPort);
                    return defaultPort;
                }
                return port;
            }
            catch (NumberFormatException ignored) {
                log.errorf("Failed to parse a port from \"forwarded\"-type headers, using the default port %d", (Object)defaultPort);
            }
        }
        return defaultPort;
    }

    private String appendPrefixToUri(String prefix, String uri) {
        String parsed = this.stripSlashes(prefix);
        return parsed.isEmpty() ? uri : "/" + parsed + uri;
    }

    private String stripSlashes(String uri) {
        String result;
        if (!uri.isEmpty()) {
            int beginIndex = 0;
            if (uri.startsWith("/")) {
                beginIndex = 1;
            }
            int endIndex = uri.length();
            if (uri.endsWith("/") && uri.length() > 1) {
                endIndex = uri.length() - 1;
            }
            result = uri.substring(beginIndex, endIndex);
        } else {
            result = uri;
        }
        return result;
    }
}

