/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.options;

import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.options.HttpServerOptionsUtils;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class TlsCertificateReloader {
    private static final List<ReloadCertificateTask> TASKS = new CopyOnWriteArrayList<ReloadCertificateTask>();
    private static final Logger LOGGER = Logger.getLogger(TlsCertificateReloader.class);

    public static long initCertReloadingAction(final Vertx vertx, final HttpServer server, HttpServerOptions options, final ServerSslConfig configuration) {
        if (options == null) {
            throw new IllegalArgumentException("Unable to configure TLS reloading - The HTTP server options were not provided");
        }
        final SSLOptions ssl = options.getSslOptions();
        if (ssl == null) {
            throw new IllegalArgumentException("Unable to configure TLS reloading - TLS/SSL is not enabled on the server");
        }
        if (configuration.certificate.reloadPeriod.isPresent()) {
            if (configuration.certificate.reloadPeriod.get().toMillis() < 30000L) {
                throw new IllegalArgumentException("Unable to configure TLS reloading - The reload period cannot be less than 30 seconds");
            }
        } else {
            return -1L;
        }
        long period = configuration.certificate.reloadPeriod.get().toMillis();
        final Supplier<CompletionStage<Boolean>> task = new Supplier<CompletionStage<Boolean>>(){

            @Override
            public CompletionStage<Boolean> get() {
                Future future = vertx.executeBlocking((Callable)new Callable<SSLOptions>(){

                    @Override
                    public SSLOptions call() throws Exception {
                        SSLOptions c = TlsCertificateReloader.reloadFileContent(ssl, configuration);
                        if (c.equals((Object)ssl)) {
                            return null;
                        }
                        return c;
                    }
                }, true).flatMap((Function)new Function<SSLOptions, Future<Boolean>>(){

                    @Override
                    public Future<Boolean> apply(SSLOptions res) {
                        if (res != null) {
                            return server.updateSSLOptions(res);
                        }
                        return Future.succeededFuture((Object)false);
                    }
                }).onComplete((Handler)new Handler<AsyncResult<Boolean>>(){

                    public void handle(AsyncResult<Boolean> ar) {
                        if (ar.failed()) {
                            LOGGER.error((Object)"Unable to reload the TLS certificate, keeping the current one.", ar.cause());
                        } else if (((Boolean)ar.result()).booleanValue()) {
                            LOGGER.debug((Object)"TLS certificates updated");
                        }
                    }
                });
                return future.toCompletionStage();
            }
        };
        long id = vertx.setPeriodic(period, (Handler)new Handler<Long>(){

            public void handle(Long id) {
                task.get();
            }
        });
        TASKS.add(new ReloadCertificateTask(id, task));
        return id;
    }

    public static void unschedule(Vertx vertx, long id) {
        vertx.cancelTimer(id);
        for (ReloadCertificateTask task : TASKS) {
            if (task.it != id) continue;
            TASKS.remove(task);
            break;
        }
    }

    public static CompletionStage<Void> reload() {
        CompletableFuture[] futures = new CompletableFuture[TASKS.size()];
        for (int i = 0; i < TASKS.size(); ++i) {
            futures[i] = TASKS.get(i).action().get().toCompletableFuture();
        }
        return CompletableFuture.allOf(futures);
    }

    private static SSLOptions reloadFileContent(SSLOptions ssl, ServerSslConfig configuration) throws IOException {
        KeyStoreOptions opts;
        SSLOptions copy = new SSLOptions(ssl);
        ArrayList keys = new ArrayList();
        ArrayList certificates = new ArrayList();
        configuration.certificate.keyFiles.ifPresent(keys::addAll);
        configuration.certificate.files.ifPresent(certificates::addAll);
        if (!certificates.isEmpty() && !keys.isEmpty()) {
            ArrayList<Buffer> certBuffer = new ArrayList<Buffer>();
            ArrayList<Buffer> keysBuffer = new ArrayList<Buffer>();
            for (Path p : certificates) {
                byte[] cert = HttpServerOptionsUtils.getFileContent(p);
                certBuffer.add(Buffer.buffer((byte[])cert));
            }
            for (Path p : keys) {
                byte[] key = HttpServerOptionsUtils.getFileContent(p);
                keysBuffer.add(Buffer.buffer((byte[])key));
            }
            PemKeyCertOptions opts2 = new PemKeyCertOptions().setCertValues(certBuffer).setKeyValues(keysBuffer);
            copy.setKeyCertOptions((KeyCertOptions)opts2);
        } else if (configuration.certificate.keyStoreFile.isPresent()) {
            opts = (KeyStoreOptions)copy.getKeyCertOptions();
            opts.setValue(Buffer.buffer((byte[])HttpServerOptionsUtils.getFileContent(configuration.certificate.keyStoreFile.get())));
            copy.setKeyCertOptions((KeyCertOptions)opts);
        }
        if (configuration.certificate.trustStoreFile.isPresent()) {
            opts = (KeyStoreOptions)copy.getKeyCertOptions();
            opts.setValue(Buffer.buffer((byte[])HttpServerOptionsUtils.getFileContent(configuration.certificate.trustStoreFile.get())));
            copy.setTrustOptions((TrustOptions)opts);
        }
        return copy;
    }

    static final class ReloadCertificateTask {
        private final long it;
        private final Supplier<CompletionStage<Boolean>> action;

        ReloadCertificateTask(long it, Supplier<CompletionStage<Boolean>> action) {
            this.it = it;
            this.action = action;
        }

        public long it() {
            return this.it;
        }

        public Supplier<CompletionStage<Boolean>> action() {
            return this.action;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ReloadCertificateTask that = (ReloadCertificateTask)obj;
            return this.it == that.it && Objects.equals(this.action, that.action);
        }

        public int hashCode() {
            return Objects.hash(this.it, this.action);
        }

        public String toString() {
            return "ReloadCertificateTask[it=" + this.it + ", action=" + this.action + "]";
        }
    }
}

