/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.xml.MarkupBuilder;
import java.util.Map;
import ratpack.groovy.guice.GroovyModuleRegistry;
import ratpack.groovy.handling.GroovyChain;
import ratpack.groovy.handling.GroovyContext;
import ratpack.groovy.handling.internal.ClosureBackedHandler;
import ratpack.groovy.handling.internal.DefaultGroovyContext;
import ratpack.groovy.handling.internal.GroovyDslChainActionTransformer;
import ratpack.groovy.internal.ClosureInvoker;
import ratpack.groovy.internal.RatpackScriptBacking;
import ratpack.groovy.markup.Markup;
import ratpack.groovy.markup.internal.DefaultMarkup;
import ratpack.groovy.templating.Template;
import ratpack.groovy.templating.internal.DefaultTemplate;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.internal.ChainBuilders;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registry;
import ratpack.util.ExceptionUtils;
import ratpack.util.Transformer;

public abstract class Groovy {
    private Groovy() {
    }

    public static void ratpack(@DelegatesTo(value=Ratpack.class, strategy=1) Closure<?> closure) {
        try {
            RatpackScriptBacking.execute(closure);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck((Throwable)e);
        }
    }

    public static Handler chain(LaunchConfig launchConfig, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return Groovy.chain(launchConfig, null, closure);
    }

    public static GroovyContext context(Context context) {
        return context instanceof GroovyContext ? (GroovyContext)context : new DefaultGroovyContext(context);
    }

    public static Handler chain(LaunchConfig launchConfig, Registry registry, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return ChainBuilders.build((LaunchConfig)launchConfig, (Transformer)new GroovyDslChainActionTransformer(launchConfig, registry), new ClosureInvoker(closure).toAction(registry, 1));
    }

    public static Template groovyTemplate(String id) {
        return Groovy.groovyTemplate(id, null);
    }

    public static Template groovyTemplate(String id, String type) {
        return Groovy.groovyTemplate(ImmutableMap.of(), id, type);
    }

    public static Template groovyTemplate(Map<String, ?> model, String id) {
        return Groovy.groovyTemplate(model, id, null);
    }

    public static Template groovyTemplate(Map<String, ?> model, String id, String type) {
        return new DefaultTemplate(id, model, type);
    }

    public static Handler groovyHandler(@DelegatesTo(value=GroovyContext.class, strategy=1) Closure<?> closure) {
        return new ClosureBackedHandler(closure);
    }

    public static Markup htmlBuilder(@DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return Groovy.markupBuilder("text/html", "UTF-8", closure);
    }

    public static Markup markupBuilder(String contentType, String encoding, @DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return new DefaultMarkup(contentType, encoding, closure);
    }

    public static interface Ratpack {
        public void modules(@DelegatesTo(value=GroovyModuleRegistry.class, strategy=1) Closure<?> var1);

        public void handlers(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> var1);
    }
}

