/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.guice.internal;

import com.google.inject.Injector;
import com.google.inject.Module;
import groovy.lang.Closure;
import java.util.List;
import javax.inject.Provider;
import ratpack.groovy.guice.GroovyModuleRegistry;
import ratpack.groovy.internal.ClosureInvoker;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.guice.ModuleRegistry;
import ratpack.guice.internal.InjectorBackedRegistry;
import ratpack.launch.LaunchConfig;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.util.Action;

public class DefaultGroovyModuleRegistry
implements GroovyModuleRegistry {
    private final ModuleRegistry moduleRegistry;

    public DefaultGroovyModuleRegistry(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public <T extends Module> void config(Class<T> moduleType, Closure<?> closure) {
        ClosureUtil.configureDelegateFirst(this.moduleRegistry.get(moduleType), closure);
    }

    @Override
    public void init(Closure<?> closure) {
        this.doInit(closure, Void.class, 2);
    }

    @Override
    public <T> void init(Class<T> clazz, Closure<?> closure) {
        this.doInit(closure, clazz, 1);
    }

    private <T, N> void doInit(final Closure<T> closure, final Class<N> clazz, final int resolveStrategy) {
        this.init(new Action<Injector>(){

            public void execute(Injector injector) throws Exception {
                InjectorBackedRegistry injectorBackedRegistry = new InjectorBackedRegistry(injector);
                Object delegate = clazz.equals(Void.class) ? null : injector.getInstance(clazz);
                new ClosureInvoker(closure).invoke((Registry)injectorBackedRegistry, delegate, resolveStrategy);
            }
        });
    }

    public LaunchConfig getLaunchConfig() {
        return this.moduleRegistry.getLaunchConfig();
    }

    public void bind(Class<?> type) {
        this.moduleRegistry.bind(type);
    }

    public <T> void bind(Class<T> publicType, Class<? extends T> implType) {
        this.moduleRegistry.bind(publicType, implType);
    }

    public <T> void bind(Class<? super T> publicType, T instance) {
        this.moduleRegistry.bind(publicType, instance);
    }

    public <T> void bind(T instance) {
        this.moduleRegistry.bind(instance);
    }

    public <T> void provider(Class<T> publicType, Class<? extends Provider<? extends T>> providerType) {
        this.moduleRegistry.provider(publicType, providerType);
    }

    public void init(Action<Injector> action) {
        this.moduleRegistry.init(action);
    }

    public void init(Class<? extends Runnable> clazz) {
        this.moduleRegistry.init(clazz);
    }

    public <O extends Module> void register(Class<O> type, O object) {
        this.moduleRegistry.register(type, object);
    }

    public void register(Module object) {
        this.moduleRegistry.register((Object)object);
    }

    public <O extends Module> O remove(Class<O> type) throws NotInRegistryException {
        return (O)((Module)this.moduleRegistry.remove(type));
    }

    public <O> O get(Class<O> type) throws NotInRegistryException {
        return (O)this.moduleRegistry.get(type);
    }

    public <O> O maybeGet(Class<O> type) {
        return (O)this.moduleRegistry.maybeGet(type);
    }

    public <O> List<O> getAll(Class<O> type) {
        return this.moduleRegistry.getAll(type);
    }
}

