/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.handling.internal;

import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.List;

public abstract class ClosureHandlerParameterListInspector {
    private ClosureHandlerParameterListInspector() {
    }

    public static List<Class<?>> retrieveParameterTypes(Closure<?> closure) {
        Object[] parameterTypes = closure.getParameterTypes();
        if (parameterTypes.length == 1 && parameterTypes[0].equals(Object.class)) {
            return Collections.emptyList();
        }
        for (Object clazz : parameterTypes) {
            if (!((Class)clazz).isArray()) continue;
            throw new IllegalStateException("Handler closure parameters cannot be array types (type: " + ((Class)clazz).getName() + ", closure: " + closure.getClass().getName() + ")");
        }
        return ImmutableList.copyOf((Object[])parameterTypes);
    }
}

