/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.handling.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import ratpack.groovy.handling.GroovyContext;
import ratpack.groovy.handling.internal.DefaultGroovyByContentHandler;
import ratpack.groovy.handling.internal.DefaultGroovyByMethodHandler;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.handling.Background;
import ratpack.handling.ByContentHandler;
import ratpack.handling.ByMethodHandler;
import ratpack.handling.Context;
import ratpack.handling.Foreground;
import ratpack.handling.Handler;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.DirectChannelAccess;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.parse.NoSuchParserException;
import ratpack.parse.Parse;
import ratpack.parse.ParserException;
import ratpack.path.PathTokens;
import ratpack.promise.SuccessOrErrorPromise;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.server.BindAddress;
import ratpack.util.Action;
import ratpack.util.ResultAction;

public class DefaultGroovyContext
implements GroovyContext {
    private final Context delegate;

    public DefaultGroovyContext(Context delegate) {
        this.delegate = delegate;
    }

    @Override
    public GroovyContext getContext() {
        return this;
    }

    public DirectChannelAccess getDirectChannelAccess() {
        return this.delegate.getDirectChannelAccess();
    }

    @Override
    public void byMethod(Closure<?> closure) {
        ByMethodHandler handler = this.getByMethod();
        DefaultGroovyByMethodHandler groovyHandler = new DefaultGroovyByMethodHandler(this, handler);
        ClosureUtil.configureDelegateFirst(groovyHandler, closure);
        try {
            groovyHandler.handle(this);
        }
        catch (Exception e) {
            this.delegate.error(e);
        }
    }

    @Override
    public void byContent(@DelegatesTo(value=ByMethodHandler.class) Closure<?> closure) {
        ByContentHandler handler = this.getByContent();
        DefaultGroovyByContentHandler groovyHandler = new DefaultGroovyByContentHandler(this, handler);
        ClosureUtil.configureDelegateFirst(groovyHandler, closure);
        try {
            groovyHandler.handle(this);
        }
        catch (Exception e) {
            this.delegate.error(e);
        }
    }

    @Override
    public void onClose(Closure<?> callback) {
        this.onClose(ClosureUtil.delegatingAction(callback));
    }

    public Request getRequest() {
        return this.delegate.getRequest();
    }

    public Response getResponse() {
        return this.delegate.getResponse();
    }

    public void next() {
        this.delegate.next();
    }

    public void next(Registry registry) {
        this.delegate.next(registry);
    }

    public void insert(Handler ... handlers) {
        this.delegate.insert(handlers);
    }

    public void insert(Registry registry, Handler ... handlers) {
        this.delegate.insert(registry, handlers);
    }

    public void respond(Handler handler) {
        this.delegate.respond(handler);
    }

    public ByMethodHandler getByMethod() {
        return this.delegate.getByMethod();
    }

    public ByContentHandler getByContent() {
        return this.delegate.getByContent();
    }

    public void error(Exception exception) throws NotInRegistryException {
        this.delegate.error(exception);
    }

    public void clientError(int statusCode) throws NotInRegistryException {
        this.delegate.clientError(statusCode);
    }

    public void withErrorHandling(Runnable runnable) {
        this.delegate.withErrorHandling(runnable);
    }

    public <T> ResultAction<T> resultAction(Action<T> action) {
        return this.delegate.resultAction(action);
    }

    public PathTokens getPathTokens() throws NotInRegistryException {
        return this.delegate.getPathTokens();
    }

    public PathTokens getAllPathTokens() throws NotInRegistryException {
        return this.delegate.getAllPathTokens();
    }

    public Path file(String path) throws NotInRegistryException {
        return this.delegate.file(path);
    }

    public void render(Object object) {
        this.delegate.render(object);
    }

    public Background getBackground() {
        return this.delegate.getBackground();
    }

    public Foreground getForeground() {
        return this.delegate.getForeground();
    }

    public <T> SuccessOrErrorPromise<T> background(Callable<T> backgroundOperation) {
        return this.delegate.background(backgroundOperation);
    }

    public void redirect(String location) throws NotInRegistryException {
        this.delegate.redirect(location);
    }

    public void redirect(int code, String location) throws NotInRegistryException {
        this.delegate.redirect(code, location);
    }

    public void lastModified(Date date, Runnable runnable) {
        this.delegate.lastModified(date, runnable);
    }

    public BindAddress getBindAddress() {
        return this.delegate.getBindAddress();
    }

    public <T> T parse(Parse<T> parse) throws NoSuchParserException, ParserException {
        return (T)this.delegate.parse(parse);
    }

    public <T> T parse(Class<T> type) throws NoSuchParserException, ParserException {
        return (T)this.delegate.parse(type);
    }

    public void onClose(Action<? super RequestOutcome> callback) {
        this.delegate.onClose(callback);
    }

    public <O> O get(Class<O> type) throws NotInRegistryException {
        return (O)this.delegate.get(type);
    }

    public <O> O maybeGet(Class<O> type) {
        return (O)this.delegate.maybeGet(type);
    }

    public <O> List<O> getAll(Class<O> type) {
        return this.delegate.getAll(type);
    }
}

