/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.List;
import ratpack.handling.internal.ServiceExtractor;
import ratpack.registry.Registry;
import ratpack.util.Action;

public class ClosureInvoker<T, D> {
    private final Closure<T> closure;
    private final List<Class<?>> parameterTypes;
    private final boolean hasDefaultParam;

    public ClosureInvoker(Closure<? extends T> closure) {
        this.closure = (Closure)closure.clone();
        this.hasDefaultParam = closure.getMaximumNumberOfParameters() > 0;
        closure.setDelegate(null);
        this.parameterTypes = ClosureInvoker.retrieveParameterTypes(this.closure);
    }

    public <T> T invoke(Registry registry, D delegate, int resolveStrategy) {
        Closure clone = (Closure)this.closure.clone();
        clone.setDelegate(delegate);
        clone.setResolveStrategy(resolveStrategy);
        if (this.parameterTypes.isEmpty()) {
            if (this.hasDefaultParam) {
                return (T)clone.call(delegate);
            }
            return (T)clone.call();
        }
        Object[] services = ServiceExtractor.extract(this.parameterTypes, (Registry)registry);
        return (T)clone.call(services);
    }

    public Action<D> toAction(final Registry registry, final int resolveStrategy) {
        return new Action<D>(){

            public void execute(D delegate) {
                ClosureInvoker.this.invoke(registry, delegate, resolveStrategy);
            }
        };
    }

    private static List<Class<?>> retrieveParameterTypes(Closure<?> closure) {
        Object[] parameterTypes = closure.getParameterTypes();
        if (parameterTypes.length == 1 && parameterTypes[0].equals(Object.class)) {
            return Collections.emptyList();
        }
        for (Object clazz : parameterTypes) {
            if (!((Class)clazz).isArray()) continue;
            throw new IllegalStateException("Closure parameters cannot be array types (type: " + ((Class)clazz).getName() + ", closure: " + closure.getClass().getName() + ")");
        }
        return ImmutableList.copyOf((Object[])parameterTypes);
    }
}

