/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import com.google.inject.Injector;
import com.google.inject.Module;
import groovy.lang.Closure;
import ratpack.groovy.Groovy;
import ratpack.groovy.guice.internal.DefaultGroovyModuleRegistry;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.InjectorHandlerTransformer;
import ratpack.guice.GuiceBackedHandlerFactory;
import ratpack.guice.ModuleRegistry;
import ratpack.handling.Handler;
import ratpack.launch.LaunchConfig;
import ratpack.util.Action;
import ratpack.util.Transformer;

public class RatpackDslClosureToHandlerTransformer
implements Transformer<Closure<?>, Handler> {
    private final LaunchConfig launchConfig;
    private final GuiceBackedHandlerFactory handlerFactory;
    private final Transformer<? super Module, ? extends Injector> moduleTransformer;

    public RatpackDslClosureToHandlerTransformer(LaunchConfig launchConfig, GuiceBackedHandlerFactory handlerFactory, Transformer<? super Module, ? extends Injector> moduleTransformer) {
        this.launchConfig = launchConfig;
        this.handlerFactory = handlerFactory;
        this.moduleTransformer = moduleTransformer;
    }

    public Handler transform(Closure<?> closure) throws Exception {
        RatpackImpl ratpack = new RatpackImpl();
        ClosureUtil.configureDelegateFirst(ratpack, closure);
        final Closure modulesConfigurer = ratpack.modulesConfigurer;
        Closure handlersConfigurer = ratpack.handlersConfigurer;
        Action<ModuleRegistry> modulesAction = new Action<ModuleRegistry>(){

            public void execute(ModuleRegistry thing) throws Exception {
                ClosureUtil.delegatingAction(modulesConfigurer).execute((Object)new DefaultGroovyModuleRegistry(thing));
            }
        };
        return this.handlerFactory.create((Action)modulesAction, this.moduleTransformer, (Transformer)new InjectorHandlerTransformer(this.launchConfig, handlersConfigurer));
    }

    static class RatpackImpl
    implements Groovy.Ratpack {
        private Closure<?> modulesConfigurer;
        private Closure<?> handlersConfigurer;

        RatpackImpl() {
        }

        @Override
        public void modules(Closure<?> modulesConfigurer) {
            this.modulesConfigurer = modulesConfigurer;
        }

        @Override
        public void handlers(Closure<?> handlersConfigurer) {
            this.handlersConfigurer = handlersConfigurer;
        }
    }
}

