/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ratpack.groovy.internal.StandaloneScriptBacking;
import ratpack.util.Action;

public abstract class RatpackScriptBacking {
    private static final ThreadLocal<Lock> LOCK_HOLDER = new ThreadLocal<Lock>(){

        @Override
        protected Lock initialValue() {
            return new ReentrantLock();
        }
    };
    private static final ThreadLocal<Action<Closure<?>>> BACKING_HOLDER = new InheritableThreadLocal<Action<Closure<?>>>(){

        @Override
        protected Action<Closure<?>> initialValue() {
            return new StandaloneScriptBacking();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withBacking(Action<Closure<?>> backing, Runnable runnable) {
        LOCK_HOLDER.get().lock();
        try {
            Action<Closure<?>> previousBacking = BACKING_HOLDER.get();
            BACKING_HOLDER.set(backing);
            try {
                runnable.run();
            }
            finally {
                BACKING_HOLDER.set(previousBacking);
            }
        }
        finally {
            LOCK_HOLDER.get().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Action<Closure<?>> swapBacking(Action<Closure<?>> backing) {
        LOCK_HOLDER.get().lock();
        try {
            Action<Closure<?>> previousBacking = BACKING_HOLDER.get();
            BACKING_HOLDER.set(backing);
            Action<Closure<?>> action = previousBacking;
            return action;
        }
        finally {
            LOCK_HOLDER.get().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Closure<?> closure) throws Exception {
        LOCK_HOLDER.get().lock();
        try {
            BACKING_HOLDER.get().execute(closure);
        }
        finally {
            LOCK_HOLDER.get().unlock();
        }
    }
}

