/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.launch;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ratpack.util.ExceptionUtils;

public class GroovyVersionChecker {
    private GroovyVersionChecker() {
    }

    public static void ensureRequiredVersionUsed(String version) throws RuntimeException {
        try {
            String minimumVersion = GroovyVersionChecker.retrieveMinimumGroovyVersion();
            if (minimumVersion == null) {
                return;
            }
            Pattern versionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*");
            Matcher minimumVersionMatcher = versionPattern.matcher(minimumVersion);
            minimumVersionMatcher.find();
            int minimumMajor = GroovyVersionChecker.groupAsInt(minimumVersionMatcher, 1);
            int minimumMinor = GroovyVersionChecker.groupAsInt(minimumVersionMatcher, 2);
            int minimumPatch = GroovyVersionChecker.groupAsInt(minimumVersionMatcher, 3);
            Matcher matcher = versionPattern.matcher(version);
            if (matcher.find()) {
                int major = GroovyVersionChecker.groupAsInt(matcher, 1);
                int minor = GroovyVersionChecker.groupAsInt(matcher, 2);
                int patch = GroovyVersionChecker.groupAsInt(matcher, 3);
                if (major > minimumMajor || major == minimumMajor && minor > minimumMinor || major == minimumMajor && minor == minimumMinor && patch >= minimumPatch) {
                    return;
                }
            }
            throw new RuntimeException("Ratpack requires Groovy " + minimumVersion + "+ to run but the version used is " + version);
        }
        catch (IOException e) {
            throw ExceptionUtils.uncheck((Throwable)e);
        }
    }

    private static int groupAsInt(Matcher matcher, int group) {
        return Integer.parseInt(matcher.group(group));
    }

    private static String retrieveMinimumGroovyVersion() throws IOException {
        URL resource = GroovyVersionChecker.class.getClassLoader().getResource("ratpack/minimum-groovy-version.txt");
        return resource == null ? null : Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
    }
}

