/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.script.internal;

import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import groovy.transform.CompileStatic;
import groovy.transform.InheritConstructors;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class ScriptEngine<T extends Script> {
    private final GroovyClassLoader classLoader;

    public ScriptEngine(ClassLoader parentLoader, boolean staticCompile, Class<T> scriptBaseClass) {
        this.classLoader = this.createClassLoader(parentLoader, staticCompile, scriptBaseClass);
    }

    public T run(String scriptName, String scriptText, Object ... scriptConstructionArgs) throws InstantiationException, IllegalAccessException {
        T script = this.create(scriptName, scriptText, scriptConstructionArgs);
        script.run();
        return script;
    }

    public T create(String scriptName, String scriptText, Object ... scriptConstructionArgs) throws IllegalAccessException, InstantiationException {
        Class<T> scriptClass = this.compile(scriptName, scriptText);
        return (T)((Script)DefaultGroovyMethods.newInstance(scriptClass, (Object[])scriptConstructionArgs));
    }

    public Class<T> compile(String scriptName, String scriptText) throws IllegalAccessException, InstantiationException {
        return this.classLoader.parseClass(scriptText, scriptName);
    }

    private GroovyClassLoader createClassLoader(ClassLoader parentLoader, final boolean staticCompile, Class<? extends Script> scriptBaseClass) {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        if (!scriptBaseClass.equals(Script.class)) {
            compilerConfiguration.setScriptBaseClass(scriptBaseClass.getName());
        }
        compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{new CompilationCustomizer(CompilePhase.CONVERSION){

            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                if (staticCompile) {
                    classNode.addAnnotation(new AnnotationNode(new ClassNode(CompileStatic.class)));
                }
                classNode.addAnnotation(new AnnotationNode(new ClassNode(InheritConstructors.class)));
            }
        }});
        return new GroovyClassLoader(parentLoader, compilerConfiguration);
    }
}

