/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import javax.inject.Singleton;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.groovy.templating.TemplatingConfig;
import ratpack.groovy.templating.internal.DefaultTemplatingConfig;
import ratpack.groovy.templating.internal.GroovyTemplateRenderingEngine;
import ratpack.groovy.templating.internal.TemplateRenderer;
import ratpack.groovy.templating.internal.TemplateRenderingClientErrorHandler;
import ratpack.groovy.templating.internal.TemplateRenderingServerErrorHandler;
import ratpack.launch.LaunchConfig;

public class TemplatingModule
extends AbstractModule {
    private String templatesPath = "templates";
    private int cacheSize = 100;
    private boolean reloadable;
    private boolean staticallyCompile;

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        this.reloadable = reloadable;
    }

    public boolean isStaticallyCompile() {
        return this.staticallyCompile;
    }

    public void setStaticallyCompile(boolean staticallyCompile) {
        this.staticallyCompile = staticallyCompile;
    }

    protected void configure() {
        this.bind(GroovyTemplateRenderingEngine.class).in(Singleton.class);
        this.bind(ClientErrorHandler.class).to(TemplateRenderingClientErrorHandler.class).in(Singleton.class);
        this.bind(ServerErrorHandler.class).to(TemplateRenderingServerErrorHandler.class).in(Singleton.class);
        this.bind(TemplateRenderer.class);
    }

    @Provides
    TemplatingConfig provideTemplatingConfig(LaunchConfig launchConfig) {
        return new DefaultTemplatingConfig(this.templatesPath, this.cacheSize, this.reloadable || launchConfig.isReloadable(), this.staticallyCompile);
    }
}

