/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import io.netty.buffer.ByteBuf;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;
import ratpack.handling.Context;
import ratpack.util.Action;
import ratpack.util.Result;
import ratpack.util.ResultAction;

class ErrorTemplateRenderResultAction
implements ResultAction<ByteBuf> {
    private static final Logger LOGGER = Logger.getLogger(ErrorTemplateRenderResultAction.class.getName());
    private final Context context;
    private final Action<? super PrintWriter> errorMsgProducer;

    public ErrorTemplateRenderResultAction(Context context, Action<? super PrintWriter> errorMsgProducer) {
        this.context = context;
        this.errorMsgProducer = errorMsgProducer;
    }

    public void execute(Result<ByteBuf> thing) throws Exception {
        if (thing.isSuccess()) {
            this.context.getResponse().send((ByteBuf)thing.getValue());
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            stringWriter.append("Exception raised during render of error page ");
            this.errorMsgProducer.execute((Object)printWriter);
            Exception failure = thing.getFailure();
            failure.printStackTrace(printWriter);
            LOGGER.warning(stringWriter.toString());
            this.context.getResponse().status(500).send("");
        }
    }
}

