/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.runtime.StackTraceUtils;
import ratpack.error.ContextualException;
import ratpack.http.Request;

public class ExceptionToTemplateModel {
    public static Map<String, ?> transform(Request request, Exception exception) {
        StackTrace stackTrace = ExceptionToTemplateModel.decodeStackTrace(exception);
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        model.put("title", exception.getClass().getName());
        model.put("message", exception.getMessage());
        model.put("stacktrace", stackTrace.html);
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        metadata.put("Request Method", request.getMethod().getName());
        metadata.put("Request URL", request.getUri());
        metadata.put("Exception Type", exception.getClass().getName());
        metadata.put("Exception Location", stackTrace.rootCause.getFileName() + ", line " + stackTrace.rootCause.getLineNumber());
        model.put("metadata", metadata);
        return model;
    }

    private static StackTrace decodeStackTrace(Exception exception) {
        StackTrace trace = new StackTrace(new StringBuilder(), null);
        trace.html.append(exception.toString()).append("\n");
        ExceptionToTemplateModel.renderFrames(exception, trace);
        return trace;
    }

    private static void renderFrames(Throwable exception, StackTrace trace) {
        exception = StackTraceUtils.sanitize((Throwable)exception);
        for (StackTraceElement ste : exception.getStackTrace()) {
            String className = ste.getClassName();
            if (!StackTraceUtils.isApplicationClass((String)className) || className.startsWith("ratpack.") && className.contains(".internal") || className.startsWith("io.netty") || className.startsWith("com.google") || className.startsWith("org.springsource.loaded")) {
                trace.html.append("<span class='stack-thirdparty'>  at ").append(ste.toString()).append("</span>\n");
                continue;
            }
            trace.html.append("  at ").append(ste.toString()).append("\n");
            if (trace.rootCause != null || ContextualException.class.isInstance(exception)) continue;
            trace.rootCause = ste;
        }
        Throwable cause = exception.getCause();
        if (cause != null) {
            trace.html.append("Caused by: ").append(cause.toString()).append("\n");
            ExceptionToTemplateModel.renderFrames(cause, trace);
        }
    }

    private static class StackTrace {
        final StringBuilder html;
        StackTraceElement rootCause;

        StackTrace(StringBuilder html, StackTraceElement rootCause) {
            this.html = html;
            this.rootCause = rootCause;
        }
    }
}

