/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.inject.Inject;
import ratpack.file.FileSystemBinding;
import ratpack.groovy.script.internal.ScriptEngine;
import ratpack.groovy.templating.TemplatingConfig;
import ratpack.groovy.templating.internal.CompiledTemplate;
import ratpack.groovy.templating.internal.DefaultTemplateScript;
import ratpack.groovy.templating.internal.PathTemplateSource;
import ratpack.groovy.templating.internal.Render;
import ratpack.groovy.templating.internal.ResourceTemplateSource;
import ratpack.groovy.templating.internal.TemplateCompiler;
import ratpack.groovy.templating.internal.TemplateSource;
import ratpack.launch.LaunchConfig;
import ratpack.util.Action;
import ratpack.util.Result;
import ratpack.util.Transformer;

public class GroovyTemplateRenderingEngine {
    private static final String ERROR_TEMPLATE = "error.html";
    private final LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache;
    private final TemplateCompiler templateCompiler;
    private final boolean reloadable;
    private final FileSystemBinding templateDir;
    private final ByteBufAllocator byteBufAllocator;

    @Inject
    public GroovyTemplateRenderingEngine(LaunchConfig launchConfig, TemplatingConfig templatingConfig) {
        this.byteBufAllocator = launchConfig.getBufferAllocator();
        ScriptEngine<DefaultTemplateScript> scriptEngine = new ScriptEngine<DefaultTemplateScript>(this.getClass().getClassLoader(), templatingConfig.isStaticallyCompile(), DefaultTemplateScript.class);
        this.templateCompiler = new TemplateCompiler(scriptEngine, this.byteBufAllocator);
        this.compiledTemplateCache = CacheBuilder.newBuilder().maximumSize((long)templatingConfig.getCacheSize()).build((CacheLoader)new CacheLoader<TemplateSource, CompiledTemplate>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CompiledTemplate load(TemplateSource templateSource) throws Exception {
                ByteBuf content = templateSource.getContent();
                try {
                    CompiledTemplate compiledTemplate = GroovyTemplateRenderingEngine.this.templateCompiler.compile(content, templateSource.getName());
                    return compiledTemplate;
                }
                finally {
                    content.release();
                }
            }
        });
        this.reloadable = templatingConfig.isReloadable();
        String templatesPath = templatingConfig.getTemplatesPath();
        this.templateDir = launchConfig.getBaseDir().binding(templatesPath);
        if (this.templateDir == null) {
            throw new IllegalStateException("templatesPath '" + templatesPath + "' is outside the file system binding");
        }
    }

    public void renderTemplate(String templateId, Map<String, ?> model, Action<Result<ByteBuf>> handler) throws Exception {
        Path templateFile = this.getTemplateFile(templateId);
        this.render(this.toTemplateSource(templateId, templateFile), model, handler);
    }

    private PathTemplateSource toTemplateSource(String templateId, Path templateFile) throws IOException {
        String id = templateId + (this.reloadable ? Files.getLastModifiedTime(templateFile, new LinkOption[0]) : "0");
        return new PathTemplateSource(id, templateFile, templateId);
    }

    public void renderError(Map<String, ?> model, Action<Result<ByteBuf>> handler) throws Exception {
        Path errorTemplate = this.getTemplateFile(ERROR_TEMPLATE);
        if (Files.exists(errorTemplate, new LinkOption[0])) {
            this.render(this.toTemplateSource(ERROR_TEMPLATE, errorTemplate), model, handler);
        } else {
            this.render(new ResourceTemplateSource(ERROR_TEMPLATE, this.byteBufAllocator), model, handler);
        }
    }

    private void render(TemplateSource templateSource, Map<String, ?> model, Action<Result<ByteBuf>> handler) throws Exception {
        try {
            new Render(this.byteBufAllocator, this.compiledTemplateCache, templateSource, model, handler, new Transformer<String, TemplateSource>(){

                public TemplateSource transform(String templateName) throws IOException {
                    return GroovyTemplateRenderingEngine.this.toTemplateSource(templateName, GroovyTemplateRenderingEngine.this.getTemplateFile(templateName));
                }
            });
        }
        catch (Exception e) {
            handler.execute((Object)new Result(e));
        }
    }

    private Path getTemplateFile(String templateName) {
        return this.templateDir.file(templateName);
    }
}

