/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import ratpack.groovy.templating.internal.CompiledTemplate;
import ratpack.groovy.templating.internal.NestedRenderer;
import ratpack.groovy.templating.internal.TemplateSource;
import ratpack.util.Action;
import ratpack.util.ExceptionUtils;
import ratpack.util.Result;
import ratpack.util.Transformer;

public class Render {
    private final LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache;
    private final Transformer<String, TemplateSource> includeTransformer;

    public Render(ByteBufAllocator byteBufAllocator, LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache, TemplateSource templateSource, Map<String, ?> model, Action<Result<ByteBuf>> handler, Transformer<String, TemplateSource> includeTransformer) throws Exception {
        this.compiledTemplateCache = compiledTemplateCache;
        this.includeTransformer = includeTransformer;
        ByteBuf byteBuf = byteBufAllocator.buffer();
        try {
            this.execute(this.getFromCache(compiledTemplateCache, templateSource), model, byteBuf);
        }
        catch (Exception e) {
            handler.execute((Object)new Result(e));
            return;
        }
        handler.execute((Object)new Result((Object)byteBuf));
    }

    private CompiledTemplate getFromCache(LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache, TemplateSource templateSource) {
        try {
            return (CompiledTemplate)compiledTemplateCache.get((Object)templateSource);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck((Throwable)ExceptionUtils.toException((Throwable)e.getCause()));
        }
    }

    private void executeNested(String templatePath, Map<String, ?> model, ByteBuf buffer) throws Exception {
        TemplateSource templateSource = (TemplateSource)this.includeTransformer.transform((Object)templatePath);
        CompiledTemplate compiledTemplate = this.getFromCache(this.compiledTemplateCache, templateSource);
        this.execute(compiledTemplate, model, buffer);
    }

    private void execute(CompiledTemplate compiledTemplate, final Map<String, ?> model, final ByteBuf parts) throws Exception {
        compiledTemplate.execute(model, parts, new NestedRenderer(){

            @Override
            public void render(String templatePath, Map<String, ?> nestedModel) throws Exception {
                HashMap modelCopy = new HashMap(model);
                modelCopy.putAll(nestedModel);
                Render.this.executeNested(templatePath, modelCopy, parts);
            }
        });
    }
}

