/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import io.netty.buffer.ByteBuf;
import javax.inject.Inject;
import ratpack.file.MimeTypes;
import ratpack.groovy.templating.Template;
import ratpack.groovy.templating.internal.GroovyTemplateRenderingEngine;
import ratpack.handling.Context;
import ratpack.render.RendererSupport;
import ratpack.util.Action;
import ratpack.util.Result;

public class TemplateRenderer
extends RendererSupport<Template> {
    private final GroovyTemplateRenderingEngine engine;

    @Inject
    public TemplateRenderer(GroovyTemplateRenderingEngine engine) {
        this.engine = engine;
    }

    public void render(final Context context, final Template template) throws Exception {
        this.engine.renderTemplate(template.getId(), template.getModel(), (Action<Result<ByteBuf>>)context.resultAction((Action)new Action<ByteBuf>(){

            public void execute(ByteBuf byteBuf) {
                String type = template.getType();
                if (type == null) {
                    type = ((MimeTypes)context.get(MimeTypes.class)).getContentType(template.getId());
                }
                context.getResponse().contentType(type).send(byteBuf);
            }
        }));
    }
}

