/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import ratpack.error.ClientErrorHandler;
import ratpack.groovy.templating.internal.ErrorTemplateRenderResultAction;
import ratpack.groovy.templating.internal.GroovyTemplateRenderingEngine;
import ratpack.handling.Context;
import ratpack.util.Action;
import ratpack.util.Result;

public class TemplateRenderingClientErrorHandler
implements ClientErrorHandler {
    public void error(Context context, final int statusCode) throws Exception {
        GroovyTemplateRenderingEngine renderer = (GroovyTemplateRenderingEngine)context.get(GroovyTemplateRenderingEngine.class);
        HashMap<String, Object> model = new HashMap<String, Object>();
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)statusCode);
        model.put("title", status.reasonPhrase());
        model.put("message", status.reasonPhrase());
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        metadata.put("Request Method", context.getRequest().getMethod().getName());
        metadata.put("Request URL", context.getRequest().getUri());
        model.put("metadata", metadata);
        context.getResponse().status(statusCode).contentType("text/html");
        renderer.renderError(model, (Action<Result<ByteBuf>>)new ErrorTemplateRenderResultAction(context, (Action<? super PrintWriter>)new Action<PrintWriter>(){

            public void execute(PrintWriter writer) {
                writer.append("for client error").append(Integer.toString(statusCode)).append("\n");
            }
        }));
    }
}

