/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import io.netty.buffer.ByteBuf;
import java.io.PrintWriter;
import java.util.Map;
import ratpack.error.ServerErrorHandler;
import ratpack.groovy.templating.internal.ErrorTemplateRenderResultAction;
import ratpack.groovy.templating.internal.ExceptionToTemplateModel;
import ratpack.groovy.templating.internal.GroovyTemplateRenderingEngine;
import ratpack.handling.Context;
import ratpack.http.Response;
import ratpack.util.Action;
import ratpack.util.Result;

public class TemplateRenderingServerErrorHandler
implements ServerErrorHandler {
    public void error(Context context, final Exception exception) throws Exception {
        GroovyTemplateRenderingEngine renderer = (GroovyTemplateRenderingEngine)context.get(GroovyTemplateRenderingEngine.class);
        Map<String, ?> model = ExceptionToTemplateModel.transform(context.getRequest(), exception);
        Response response = context.getResponse();
        if (response.getStatus().getCode() < 400) {
            response.status(500);
        }
        renderer.renderError(model, (Action<Result<ByteBuf>>)new ErrorTemplateRenderResultAction(context, (Action<? super PrintWriter>)new Action<PrintWriter>(){

            public void execute(PrintWriter writer) {
                writer.append("for server error\n");
                exception.printStackTrace(writer);
            }
        }));
    }
}

