/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.markuptemplates.internal;

import groovy.lang.Writable;
import groovy.text.Template;
import groovy.text.markup.MarkupTemplateEngine;
import java.io.IOException;
import javax.inject.Inject;
import ratpack.file.MimeTypes;
import ratpack.groovy.markuptemplates.MarkupTemplate;
import ratpack.handling.Context;
import ratpack.render.RendererSupport;

public class MarkupTemplateRenderer
extends RendererSupport<MarkupTemplate> {
    private final MarkupTemplateEngine engine;

    @Inject
    public MarkupTemplateRenderer(MarkupTemplateEngine engine) {
        this.engine = engine;
    }

    public void render(Context context, MarkupTemplate template) throws Exception {
        String contentType = template.getContentType();
        contentType = contentType == null ? ((MimeTypes)context.get(MimeTypes.class)).getContentType(template.getName()) : contentType;
        try {
            Template compiledTemplate = this.engine.createTemplateByPath(template.getName());
            Writable boundTemplate = compiledTemplate.make(template.getModel());
            context.getResponse().send((CharSequence)contentType, boundTemplate.toString());
        }
        catch (IOException e) {
            context.error((Throwable)e);
        }
    }
}

