/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import javax.inject.Inject;
import ratpack.file.MimeTypes;
import ratpack.groovy.templating.Template;
import ratpack.groovy.templating.internal.GroovyTemplateRenderingEngine;
import ratpack.handling.Context;
import ratpack.render.RendererSupport;
import ratpack.util.ExceptionUtils;

public class TemplateRenderer
extends RendererSupport<Template> {
    private final GroovyTemplateRenderingEngine engine;
    private final ByteBufAllocator byteBufAllocator;

    @Inject
    public TemplateRenderer(GroovyTemplateRenderingEngine engine, ByteBufAllocator byteBufAllocator) {
        this.engine = engine;
        this.byteBufAllocator = byteBufAllocator;
    }

    public void render(Context context, Template template) throws Exception {
        ByteBuf buffer = this.byteBufAllocator.buffer();
        this.engine.renderTemplate(buffer, template.getId(), template.getModel()).onError(thing -> {
            buffer.release();
            throw ExceptionUtils.toException((Throwable)thing);
        }).then(byteBuf -> {
            String type = template.getType();
            if (type == null) {
                type = ((MimeTypes)context.get(MimeTypes.class)).getContentType(template.getId());
            }
            context.getResponse().contentType((CharSequence)type).send(byteBuf);
        });
    }
}

