/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.launch.internal;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GroovyVersionCheck {
    private GroovyVersionCheck() {
    }

    public static void ensureRequiredVersionUsed(String groovyVersion) throws RuntimeException {
        String minimumVersion = GroovyVersionCheck.maybeLoadMinimumGroovyVersion();
        if (minimumVersion != null) {
            GroovyVersionCheck.ensureRequiredVersionUsed(groovyVersion, minimumVersion);
        }
    }

    static void ensureRequiredVersionUsed(String groovyVersion, String minimumVersion) {
        Pattern versionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*");
        Matcher minimumVersionMatcher = versionPattern.matcher(minimumVersion);
        if (!minimumVersionMatcher.find()) {
            throw new IllegalStateException("Minimum groovy isn't in expected format");
        }
        int minimumMajor = GroovyVersionCheck.groupAsInt(minimumVersionMatcher, 1);
        int minimumMinor = GroovyVersionCheck.groupAsInt(minimumVersionMatcher, 2);
        int minimumPatch = GroovyVersionCheck.groupAsInt(minimumVersionMatcher, 3);
        Matcher matcher = versionPattern.matcher(groovyVersion);
        if (matcher.find()) {
            int major = GroovyVersionCheck.groupAsInt(matcher, 1);
            int minor = GroovyVersionCheck.groupAsInt(matcher, 2);
            int patch = GroovyVersionCheck.groupAsInt(matcher, 3);
            if (major > minimumMajor || major == minimumMajor && minor > minimumMinor || major == minimumMajor && minor == minimumMinor && patch >= minimumPatch) {
                return;
            }
        }
        throw new RuntimeException("Ratpack requires Groovy " + minimumVersion + "+ to run but the version used is " + groovyVersion);
    }

    private static int groupAsInt(Matcher matcher, int group) {
        return Integer.parseInt(matcher.group(group));
    }

    public static String maybeLoadMinimumGroovyVersion() {
        URL resource = GroovyVersionCheck.class.getClassLoader().getResource("ratpack/minimum-groovy-version.txt");
        try {
            return resource == null ? null : Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
    }
}

