/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template;

import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import groovy.text.markup.MarkupTemplateEngine;
import groovy.text.markup.TemplateConfiguration;
import groovy.text.markup.TemplateResolver;
import java.nio.file.Path;
import javax.inject.Singleton;
import ratpack.groovy.template.MarkupTemplate;
import ratpack.groovy.template.internal.CachingTemplateResolver;
import ratpack.groovy.template.internal.MarkupTemplateRenderer;
import ratpack.guice.ConfigurableModule;
import ratpack.launch.LaunchConfig;
import ratpack.render.Renderer;

public class MarkupTemplateModule
extends ConfigurableModule<Config> {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Renderer<MarkupTemplate>>(){}).to(MarkupTemplateRenderer.class).in(Singleton.class);
    }

    protected void defaultConfig(LaunchConfig launchConfig, Config config) {
        config.setAutoEscape(true);
        config.setCacheTemplates(!launchConfig.isDevelopment());
    }

    @Provides
    @Singleton
    MarkupTemplateEngine provideTemplateEngine(LaunchConfig launchConfig, Config config) {
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        TemplateConfiguration effectiveConfiguration = new TemplateConfiguration((TemplateConfiguration)config);
        effectiveConfiguration.setCacheTemplates(config.isCacheTemplates());
        Path templatesDir = launchConfig.getBaseDir().file(config.getTemplatesDirectory());
        return new MarkupTemplateEngine(parent, effectiveConfiguration, (TemplateResolver)new CachingTemplateResolver(templatesDir));
    }

    public static class Config
    extends TemplateConfiguration {
        private String templatesDirectory = "templates";

        public String getTemplatesDirectory() {
            return this.templatesDirectory;
        }

        public void setTemplatesDirectory(String templatesDirectory) {
            this.templatesDirectory = templatesDirectory;
        }
    }
}

