/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import io.netty.util.CharsetUtil;
import java.nio.file.Path;
import ratpack.func.BiFunction;
import ratpack.func.Factory;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.reload.internal.ReloadableFileBackedFactory;

public class ScriptBackedHandler
implements Handler {
    private final Factory<Handler> reloadHandler;
    private final Path script;

    public ScriptBackedHandler(Path script, boolean reloadable, BiFunction<? super Path, ? super String, ? extends Handler> capture) throws Exception {
        this.script = script;
        this.reloadHandler = new ReloadableFileBackedFactory(script, reloadable, (file, bytes) -> {
            String string = bytes.toString(CharsetUtil.UTF_8);
            return (Handler)capture.apply((Object)script, (Object)string);
        });
        if (reloadable) {
            new Thread(() -> {
                try {
                    this.reloadHandler.create();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).run();
        } else {
            this.reloadHandler.create();
        }
    }

    public void handle(Context context) throws Exception {
        Handler handler = (Handler)this.reloadHandler.create();
        if (handler == null) {
            context.getResponse().send("script file does not exist:" + this.script.toAbsolutePath());
        } else {
            handler.handle(context);
        }
    }
}

