/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import ratpack.func.Action;
import ratpack.groovy.Groovy;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.GroovyVersionCheck;
import ratpack.server.RatpackServer;

public class StandaloneScriptBacking
implements Action<Closure<?>> {
    private static final AtomicReference<Action<? super RatpackServer>> CAPTURE_ACTION = new AtomicReference<Object>(null);

    public static void captureNext(Action<? super RatpackServer> action) {
        CAPTURE_ACTION.set(action);
    }

    public void execute(Closure<?> closure) throws Exception {
        GroovyVersionCheck.ensureRequiredVersionUsed(GroovySystem.getVersion());
        Path scriptFile = ClosureUtil.findScript(closure);
        if (scriptFile == null) {
            throw new IllegalStateException("Could not find script file for closure: " + closure.toString());
        }
        RatpackServer server = RatpackServer.of(Groovy.Script.app(scriptFile));
        Action action = CAPTURE_ACTION.getAndSet(null);
        if (action != null) {
            action.execute((Object)server);
        }
        server.start();
    }
}

