/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.guice.internal;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import ratpack.func.Action;
import ratpack.groovy.guice.GroovyBindingsSpec;
import ratpack.guice.BindingsSpec;
import ratpack.guice.ConfigurableModule;
import ratpack.server.ServerConfig;

public class DefaultGroovyBindingsSpec
implements GroovyBindingsSpec {
    private final BindingsSpec delegate;

    public DefaultGroovyBindingsSpec(BindingsSpec delegate) {
        this.delegate = delegate;
    }

    public ServerConfig getServerConfig() {
        return this.delegate.getServerConfig();
    }

    @Override
    public GroovyBindingsSpec bind(Class<?> type) {
        this.delegate.bind(type);
        return this;
    }

    @Override
    public <T> GroovyBindingsSpec bind(TypeLiteral<T> publicType, Class<? extends T> implType) {
        this.delegate.bind(publicType, implType);
        return this;
    }

    @Override
    public <T> GroovyBindingsSpec bindInstance(TypeLiteral<? super T> publicType, T instance) {
        this.delegate.bindInstance(publicType, instance);
        return this;
    }

    @Override
    public <T> GroovyBindingsSpec bindInstance(T instance) {
        this.delegate.bindInstance(instance);
        return this;
    }

    @Override
    public <T> GroovyBindingsSpec providerType(TypeLiteral<T> publicType, Class<? extends Provider<? extends T>> providerType) {
        this.delegate.providerType(publicType, providerType);
        return this;
    }

    @Override
    public <T> GroovyBindingsSpec provider(TypeLiteral<T> publicType, Provider<? extends T> provider) {
        this.delegate.provider(publicType, provider);
        return this;
    }

    @Override
    public GroovyBindingsSpec binder(Action<? super Binder> action) {
        this.delegate.binder(action);
        return this;
    }

    @Override
    public GroovyBindingsSpec add(Module module) {
        this.delegate.add(module);
        return this;
    }

    @Override
    public GroovyBindingsSpec add(Class<? extends Module> module) {
        this.delegate.add(module);
        return this;
    }

    @Override
    public <C, T extends ConfigurableModule<C>> GroovyBindingsSpec add(Class<T> moduleClass, Action<? super C> configurer) {
        this.delegate.add(moduleClass, configurer);
        return this;
    }

    @Override
    public <C> GroovyBindingsSpec add(ConfigurableModule<C> module, Action<? super C> configurer) {
        this.delegate.add(module, configurer);
        return this;
    }

    @Override
    public <C, T extends ConfigurableModule<C>> GroovyBindingsSpec addConfig(Class<T> moduleClass, C config, Action<? super C> configurer) {
        this.delegate.addConfig(moduleClass, config, configurer);
        return this;
    }

    @Override
    public <C> GroovyBindingsSpec addConfig(ConfigurableModule<C> module, C config, Action<? super C> configurer) {
        this.delegate.addConfig(module, config, configurer);
        return this;
    }
}

