/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovySystem;
import groovy.xml.MarkupBuilder;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.func.BiFunction;
import ratpack.func.Function;
import ratpack.groovy.handling.GroovyChain;
import ratpack.groovy.handling.GroovyContext;
import ratpack.groovy.handling.internal.ClosureBackedHandler;
import ratpack.groovy.handling.internal.DefaultGroovyChain;
import ratpack.groovy.handling.internal.DefaultGroovyContext;
import ratpack.groovy.handling.internal.GroovyDslChainActionTransformer;
import ratpack.groovy.internal.ClosureInvoker;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.GroovyVersionCheck;
import ratpack.groovy.internal.ScriptBackedHandler;
import ratpack.groovy.internal.capture.BindingsOnly;
import ratpack.groovy.internal.capture.HandlersOnly;
import ratpack.groovy.internal.capture.RatpackDslBacking;
import ratpack.groovy.internal.capture.RatpackDslClosures;
import ratpack.groovy.internal.capture.RatpackDslScriptCapture;
import ratpack.groovy.internal.capture.RatpackScriptBacking;
import ratpack.groovy.script.ScriptNotFoundException;
import ratpack.groovy.template.Markup;
import ratpack.groovy.template.MarkupTemplate;
import ratpack.groovy.template.TextTemplate;
import ratpack.guice.BindingsSpec;
import ratpack.guice.Guice;
import ratpack.handling.Chain;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.internal.ChainBuilders;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.registry.Registry;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ServerConfig;
import ratpack.server.internal.BaseDirFinder;
import ratpack.server.internal.FileBackedReloadInformant;
import ratpack.util.Exceptions;
import ratpack.util.internal.IoUtils;

public abstract class Groovy {
    private Groovy() {
    }

    public static void ratpack(@DelegatesTo(value=Ratpack.class, strategy=1) Closure<?> closure) {
        try {
            RatpackScriptBacking.execute(closure);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public static Handler chain(ServerConfig serverConfig, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return Groovy.chain(serverConfig, null, closure);
    }

    public static GroovyContext context(Context context) {
        return context instanceof GroovyContext ? (GroovyContext)context : new DefaultGroovyContext(context);
    }

    public static Handler chain(ServerConfig serverConfig, Registry registry, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return ChainBuilders.build((serverConfig != null && serverConfig.isDevelopment() ? 1 : 0) != 0, (Function)new GroovyDslChainActionTransformer(serverConfig, registry), new ClosureInvoker(closure).toAction(registry, 1));
    }

    public static Handler chain(Registry registry, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return Groovy.chain((ServerConfig)registry.get(ServerConfig.class), registry, closure);
    }

    public static Action<Chain> chainAction(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return chain -> ClosureUtil.configureDelegateFirst(new DefaultGroovyChain((Chain)chain), closure);
    }

    public static TextTemplate groovyTemplate(String id) {
        return Groovy.groovyTemplate(id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id) {
        return Groovy.groovyMarkupTemplate(id, (String)null);
    }

    public static TextTemplate groovyTemplate(String id, String type) {
        return Groovy.groovyTemplate(ImmutableMap.of(), id, type);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id, String type) {
        return Groovy.groovyMarkupTemplate(ImmutableMap.of(), id, type);
    }

    public static TextTemplate groovyTemplate(Map<String, ?> model, String id) {
        return Groovy.groovyTemplate(model, id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(Map<String, ?> model, String id) {
        return Groovy.groovyMarkupTemplate(model, id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id, Action<? super ImmutableMap.Builder<String, Object>> modelBuilder) {
        return Groovy.groovyMarkupTemplate(id, null, modelBuilder);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id, String type, Action<? super ImmutableMap.Builder<String, Object>> modelBuilder) {
        ImmutableMap model = (ImmutableMap)Exceptions.uncheck(() -> ((ImmutableMap.Builder)Action.with((Object)ImmutableMap.builder(), (Action)Action.noopIfNull((Action)modelBuilder))).build());
        return Groovy.groovyMarkupTemplate(model, id, type);
    }

    public static TextTemplate groovyTemplate(Map<String, ?> model, String id, String type) {
        return new TextTemplate(model, id, type);
    }

    public static MarkupTemplate groovyMarkupTemplate(Map<String, ?> model, String id, String type) {
        return new MarkupTemplate(id, type, model);
    }

    public static Handler groovyHandler(@DelegatesTo(value=GroovyContext.class, strategy=1) Closure<?> closure) {
        return new ClosureBackedHandler(closure);
    }

    public static void chain(Chain chain, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        GroovyChain groovyChain = chain instanceof GroovyChain ? (GroovyChain)chain : new DefaultGroovyChain(chain);
        new ClosureInvoker(closure).invoke(chain.getRegistry(), groovyChain, 1);
    }

    public static Action<Chain> chain(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return c -> Groovy.chain(c, closure);
    }

    public static Markup htmlBuilder(@DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return Groovy.markupBuilder(HttpHeaderConstants.HTML_UTF_8, CharsetUtil.UTF_8, closure);
    }

    public static Markup markupBuilder(CharSequence contentType, CharSequence encoding, @DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return new Markup(contentType, Charset.forName(encoding.toString()), closure);
    }

    public static Markup markupBuilder(CharSequence contentType, Charset encoding, @DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return new Markup(contentType, encoding, closure);
    }

    public static abstract class Script {
        public static final String DEFAULT_HANDLERS_PATH = "handlers.groovy";
        public static final String DEFAULT_BINDINGS_PATH = "bindings.groovy";
        public static final String DEFAULT_APP_PATH = "ratpack.groovy";

        private Script() {
        }

        public static void checkGroovy() {
            GroovyVersionCheck.ensureRequiredVersionUsed(GroovySystem.getVersion());
        }

        public static Action<? super RatpackServerSpec> app() {
            return Script.app(false);
        }

        public static Action<? super RatpackServerSpec> app(boolean staticCompile) {
            return Script.app(staticCompile, DEFAULT_APP_PATH, DEFAULT_APP_PATH.substring(0, 1).toUpperCase() + DEFAULT_APP_PATH.substring(1));
        }

        public static Action<? super RatpackServerSpec> app(Path script) {
            return Script.app(false, script);
        }

        public static Action<? super RatpackServerSpec> app(boolean compileStatic, Path script) {
            return b -> Script.doApp(b, compileStatic, script.getParent(), script);
        }

        public static Action<? super RatpackServerSpec> app(boolean staticCompile, String ... scriptPaths) {
            return b -> {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                BaseDirFinder.Result baseDirResult = Arrays.stream(scriptPaths).map(scriptPath -> BaseDirFinder.find((ClassLoader)classLoader, (String)scriptPath)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new ScriptNotFoundException(scriptPaths));
                Path baseDir = baseDirResult.getBaseDir();
                Path scriptFile = baseDirResult.getResource();
                Script.doApp(b, staticCompile, baseDir, scriptFile);
            };
        }

        private static void doApp(RatpackServerSpec definition, boolean staticCompile, Path baseDir, Path scriptFile) throws Exception {
            String script = IoUtils.read((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (Path)scriptFile).toString(CharsetUtil.UTF_8);
            RatpackDslClosures closures = new RatpackDslScriptCapture(staticCompile, (Function<? super RatpackDslClosures, ? extends Ratpack>)((Function)RatpackDslBacking::new)).apply(scriptFile, script);
            definition.serverConfig(ClosureUtil.configureDelegateFirstAndReturn(Script.loadPropsIfPresent(ServerConfig.baseDir((Path)baseDir), baseDir), closures.getServerConfig()));
            definition.registry(r -> (Registry)Guice.registry(bindingsSpec -> {
                bindingsSpec.bindInstance((Object)new FileBackedReloadInformant(scriptFile));
                ClosureUtil.configureDelegateFirst(bindingsSpec, closures.getBindings());
            }).apply(r));
            definition.handler(r -> Groovy.chain(r, closures.getHandlers()));
        }

        private static ServerConfig.Builder loadPropsIfPresent(ServerConfig.Builder serverConfigBuilder, Path baseDir) {
            Path propsFile = baseDir.resolve(".ratpack");
            if (Files.exists(propsFile, new LinkOption[0])) {
                serverConfigBuilder.props(propsFile);
            }
            return serverConfigBuilder;
        }

        public static Function<Registry, Handler> handlers() {
            return Script.handlers(false);
        }

        public static Function<Registry, Handler> handlers(boolean staticCompile) {
            return Script.handlers(staticCompile, DEFAULT_HANDLERS_PATH);
        }

        public static Function<Registry, Handler> handlers(boolean staticCompile, String scriptPath) {
            Script.checkGroovy();
            return r -> {
                Path scriptFile = ((FileSystemBinding)r.get(FileSystemBinding.class)).file(scriptPath);
                boolean development = ((ServerConfig)r.get(ServerConfig.class)).isDevelopment();
                return new ScriptBackedHandler(scriptFile, development, (BiFunction<? super Path, ? super String, ? extends Handler>)new RatpackDslScriptCapture(staticCompile, (Function<? super RatpackDslClosures, ? extends Ratpack>)((Function)HandlersOnly::new)).andThen(RatpackDslClosures::getHandlers).andThen(c -> Groovy.chain(r, c)));
            };
        }

        public static Function<Registry, Registry> bindings() {
            return Script.bindings(false);
        }

        public static Function<Registry, Registry> bindings(boolean staticCompile) {
            return Script.bindings(staticCompile, DEFAULT_BINDINGS_PATH);
        }

        public static Function<Registry, Registry> bindings(boolean staticCompile, String scriptPath) {
            Script.checkGroovy();
            return r -> {
                Path scriptFile = ((FileSystemBinding)r.get(FileSystemBinding.class)).file(scriptPath);
                String script = IoUtils.read((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (Path)scriptFile).toString(CharsetUtil.UTF_8);
                Closure bindingsClosure = (Closure)new RatpackDslScriptCapture(staticCompile, (Function<? super RatpackDslClosures, ? extends Ratpack>)((Function)BindingsOnly::new)).andThen(RatpackDslClosures::getBindings).apply((Object)scriptFile, (Object)script);
                return (Registry)Guice.registry(bindingsSpec -> {
                    bindingsSpec.bindInstance((Object)new FileBackedReloadInformant(scriptFile));
                    ClosureUtil.configureDelegateFirst(bindingsSpec, bindingsClosure);
                }).apply(r);
            };
        }
    }

    public static interface Ratpack {
        public void bindings(@DelegatesTo(value=BindingsSpec.class, strategy=1) Closure<?> var1);

        public void handlers(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> var1);

        public void serverConfig(@DelegatesTo(value=ServerConfig.Builder.class, strategy=1) Closure<?> var1);
    }
}

