/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.guice.internal;

import com.google.inject.Injector;
import com.google.inject.Module;
import groovy.lang.Closure;
import javax.inject.Provider;
import ratpack.func.Action;
import ratpack.groovy.guice.GroovyBindingsSpec;
import ratpack.groovy.internal.ClosureInvoker;
import ratpack.guice.BindingsSpec;
import ratpack.guice.internal.InjectorBackedRegistry;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registry;

public class DefaultGroovyBindingsSpec
implements GroovyBindingsSpec {
    private final BindingsSpec bindingsSpec;

    public DefaultGroovyBindingsSpec(BindingsSpec bindingsSpec) {
        this.bindingsSpec = bindingsSpec;
    }

    @Override
    public void init(Closure<?> closure) {
        this.doInit(closure, Void.class, 2);
    }

    private <T, N> void doInit(final Closure<T> closure, final Class<N> clazz, final int resolveStrategy) {
        this.init(new Action<Injector>(){

            public void execute(Injector injector) throws Exception {
                InjectorBackedRegistry injectorBackedRegistry = new InjectorBackedRegistry(injector);
                Object delegate = clazz.equals(Void.class) ? null : injector.getInstance(clazz);
                new ClosureInvoker(closure).invoke((Registry)injectorBackedRegistry, delegate, resolveStrategy);
            }
        });
    }

    public LaunchConfig getLaunchConfig() {
        return this.bindingsSpec.getLaunchConfig();
    }

    public void bind(Class<?> type) {
        this.bindingsSpec.bind(type);
    }

    public <T> void bind(Class<T> publicType, Class<? extends T> implType) {
        this.bindingsSpec.bind(publicType, implType);
    }

    public <T> void bind(Class<? super T> publicType, T instance) {
        this.bindingsSpec.bind(publicType, instance);
    }

    public <T> void bind(T instance) {
        this.bindingsSpec.bind(instance);
    }

    public <T> void provider(Class<T> publicType, Class<? extends Provider<? extends T>> providerType) {
        this.bindingsSpec.provider(publicType, providerType);
    }

    public void init(Action<Injector> action) {
        this.bindingsSpec.init(action);
    }

    public void init(Class<? extends Runnable> clazz) {
        this.bindingsSpec.init(clazz);
    }

    public <T extends Module> T config(Class<T> moduleClass) {
        return (T)this.bindingsSpec.config(moduleClass);
    }

    public void add(Module ... modules) {
        this.bindingsSpec.add(modules);
    }

    public void add(Iterable<? extends Module> modules) {
        this.bindingsSpec.add(modules);
    }
}

