/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import ratpack.func.Action;

public abstract class ClosureUtil {
    private ClosureUtil() {
    }

    public static <D, R> R configureDelegateOnly(@DelegatesTo.Target D delegate, @DelegatesTo(strategy=3) Closure<R> configurer) {
        return ClosureUtil.configure(delegate, delegate, configurer, 3);
    }

    public static <D, R> R configureDelegateFirst(@DelegatesTo.Target D delegate, @DelegatesTo(strategy=1) Closure<R> configurer) {
        return ClosureUtil.configure(delegate, delegate, configurer, 1);
    }

    public static <D, A, R> R configureDelegateFirst(@DelegatesTo.Target D delegate, A argument, @DelegatesTo(strategy=1) Closure<R> configurer) {
        return ClosureUtil.configure(delegate, argument, configurer, 1);
    }

    private static <R, D, A> R configure(D delegate, A argument, Closure<R> configurer, int resolveStrategy) {
        if (configurer == null) {
            return null;
        }
        Closure clone = (Closure)configurer.clone();
        clone.setDelegate(delegate);
        clone.setResolveStrategy(resolveStrategy);
        if (clone.getMaximumNumberOfParameters() == 0) {
            return (R)clone.call();
        }
        return (R)clone.call(argument);
    }

    public static <T> Action<T> delegatingAction(Class<T> type, final Closure<?> configurer) {
        return new Action<T>(){

            public void execute(T object) throws Exception {
                ClosureUtil.configureDelegateFirst(object, configurer);
            }
        };
    }

    public static <T> Action<T> delegatingAction(Closure<?> configurer) {
        return ClosureUtil.delegatingAction(Object.class, configurer);
    }

    public static Action<Object> action(Closure<?> closure) {
        Closure copy = closure.rehydrate(null, closure.getOwner(), closure.getThisObject());
        return new NoDelegateClosureAction(copy);
    }

    public static <D, A> Runnable delegateFirstRunnable(D delegate, A argument, Closure<?> closure) {
        return new DelegatingClosureRunnable(delegate, argument, closure);
    }

    public static <T> Closure<T> returning(T thing) {
        return new PassThroughClosure<T>(thing);
    }

    public static Closure<Void> noop() {
        return ClosureUtil.returning(null);
    }

    private static class PassThroughClosure<T>
    extends Closure<T> {
        static final long serialVersionUID = 0L;
        private final T thing;

        public PassThroughClosure(T thing) {
            super(null);
            this.thing = thing;
        }

        protected T doCall() {
            return this.thing;
        }
    }

    private static class DelegatingClosureRunnable<D, A>
    implements Runnable {
        private final D delegate;
        private final A argument;
        private final Closure<?> closure;

        private DelegatingClosureRunnable(D delegate, A argument, Closure<?> closure) {
            this.delegate = delegate;
            this.argument = argument;
            this.closure = closure;
        }

        @Override
        public void run() {
            ClosureUtil.configureDelegateFirst(this.delegate, this.argument, this.closure);
        }
    }

    private static class NoDelegateClosureAction
    implements Action<Object> {
        private final Closure<?> copy;

        public NoDelegateClosureAction(Closure<?> copy) {
            this.copy = copy;
        }

        public void execute(Object thing) throws Exception {
            this.copy.call(thing);
        }
    }
}

