/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.launch;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import ratpack.func.Function;
import ratpack.groovy.internal.RatpackDslClosureToHandlerTransformer;
import ratpack.groovy.internal.ScriptBackedApp;
import ratpack.groovy.server.internal.GroovyKitAppFactory;
import ratpack.guice.Guice;
import ratpack.guice.GuiceBackedHandlerFactory;
import ratpack.handling.Handler;
import ratpack.launch.HandlerFactory;
import ratpack.launch.LaunchConfig;

public class GroovyScriptFileHandlerFactory
implements HandlerFactory {
    public static final String SCRIPT_PROPERTY_NAME = "groovy.script";
    public static final String SCRIPT_PROPERTY_DEFAULT = "ratpack.groovy";
    public static final String COMPILE_STATIC_PROPERTY_NAME = "groovy.compileStatic";
    public static final String COMPILE_STATIC_PROPERTY_DEFAULT = "false";

    public Handler create(LaunchConfig launchConfig) {
        Path capitalized;
        String scriptName = launchConfig.getOther(SCRIPT_PROPERTY_NAME, SCRIPT_PROPERTY_DEFAULT);
        Path script = launchConfig.getBaseDir().file(scriptName);
        if (script == null) {
            throw new IllegalStateException("scriptName '" + scriptName + "' escapes application base dir");
        }
        if (!Files.exists(script, new LinkOption[0]) && (capitalized = launchConfig.getBaseDir().file(scriptName.substring(0, 1).toUpperCase() + scriptName.substring(1))) != null && Files.exists(capitalized, new LinkOption[0])) {
            script = capitalized;
        }
        try {
            script = script.toRealPath(new LinkOption[0]);
        }
        catch (IOException ignore) {
            // empty catch block
        }
        boolean compileStatic = Boolean.parseBoolean(launchConfig.getOther(COMPILE_STATIC_PROPERTY_NAME, COMPILE_STATIC_PROPERTY_DEFAULT));
        Function moduleTransformer = Guice.newInjectorFactory((LaunchConfig)launchConfig);
        GroovyKitAppFactory handlerFactory = new GroovyKitAppFactory(launchConfig);
        RatpackDslClosureToHandlerTransformer closureTransformer = new RatpackDslClosureToHandlerTransformer(launchConfig, (GuiceBackedHandlerFactory)handlerFactory, (Function<? super Module, ? extends Injector>)moduleTransformer);
        return new ScriptBackedApp(script, compileStatic, launchConfig.isReloadable(), closureTransformer);
    }
}

