/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.InputStream;
import ratpack.groovy.templating.internal.TemplateSource;
import ratpack.util.internal.IoUtils;

class ResourceTemplateSource
implements TemplateSource {
    private final String resourcePath;
    private final ByteBufAllocator byteBufAllocator;

    ResourceTemplateSource(String resourcePath, ByteBufAllocator byteBufAllocator) {
        this.resourcePath = resourcePath;
        this.byteBufAllocator = byteBufAllocator;
    }

    @Override
    public String getName() {
        return this.resourcePath;
    }

    @Override
    public ByteBuf getContent() throws IOException {
        ByteBuf buffer = this.byteBufAllocator.buffer();
        try {
            IoUtils.writeTo((InputStream)this.getClass().getResourceAsStream(this.resourcePath), (ByteBuf)buffer);
        }
        catch (IOException e) {
            buffer.release();
            throw e;
        }
        return buffer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceTemplateSource that = (ResourceTemplateSource)o;
        return this.resourcePath.equals(that.resourcePath);
    }

    public int hashCode() {
        return this.resourcePath.hashCode();
    }
}

